﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 上传设置仓储层
    /// </summary>
    public class RB_File_StoreRepository : RepositoryBase<RB_File_Store>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_File_Store); } }

        /// <summary>
        /// 获取上传存储信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_File_Store> GetListRepository(RB_File_Store query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_File_Store.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_File_Store.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_File_Store.MallBaseId)}={query.MallBaseId}");
                }
                if (query.StoreType > 0)
                {
                    builder.Append($" AND {nameof(RB_File_Store.StoreType)}={(int)query.StoreType}");
                }
            }
            return Get<RB_File_Store>(builder.ToString()).ToList();
        }
    }
}
