﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.AppletWeChat
{
    /// <summary>
    /// 微信小程序消息通知模板
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_AppletWechat_MsgEmplate
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 下单成功提醒
        /// </summary>
        public string OrderSucceed { get; set; }

        /// <summary>
        /// 订单取消通知
        /// </summary>
        public string OrderCancel { get; set; }

        /// <summary>
        /// 订单发货通知
        /// </summary>
        public string OrderDeliver { get; set; }

        /// <summary>
        /// 退款通知
        /// </summary>
        public string OrderRefund { get; set; }

        /// <summary>
        /// 活动状态通知
        /// </summary>
        public string ActivityState { get; set; }

        /// <summary>
        /// 审核结果通知
        /// </summary>
        public string AuditResult { get; set; }

        /// <summary>
        /// 提现成功通知
        /// </summary>
        public string WithdrawSucceed { get; set; }

        /// <summary>
        /// 提现审核失败通知
        /// </summary>
        public string WithdrawFail { get; set; }

        /// <summary>
        /// 会员等级变更通知
        /// </summary>
        public string MemberLevel { get; set; }
    }
}
