﻿using Mall.Model.Entity.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.AppletWeChat
{
    /// <summary>
    /// 微信小程序消息模板仓储层
    /// </summary>
    public class RB_AppletWechat_MsgEmplateRepository : RepositoryBase<RB_AppletWechat_MsgEmplate>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_AppletWechat_MsgEmplate); } }



        /// <summary>
        /// 获取微信小程序消息模板
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_AppletWechat_MsgEmplate> GetMsgEmplateList(RB_AppletWechat_MsgEmplate query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWechat_MsgEmplate.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWechat_MsgEmplate.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_AppletWechat_MsgEmplate.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_AppletWechat_MsgEmplate>(builder.ToString()).ToList();
        }
    }
}
