﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common.Enum.Goods;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单仓储层
    /// </summary>
    public class RB_Goods_OrderRepository : RepositoryBase<RB_Goods_Order>
    {

        /// <summary>
        /// 获取订单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_Extend> GetOrderPageList(int pageIndex,int pageSize,out long count,RB_Goods_Order_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderSource > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.OrderSource)}={(int)dmodel.OrderSource}";
            }
            if (dmodel.OrderType > 0) {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.DeliveryMethod > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.DeliveryMethod)}={(int)dmodel.DeliveryMethod}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (dmodel.OrderStatus > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)dmodel.OrderStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo)) {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.MerchantsNo)) {
                where += $@" and o.{nameof(RB_Goods_Order.MerchantsNo)} like '%{dmodel.MerchantsNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName)) {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }
            if (dmodel.UserId > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.UserId)}={(int)dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName)) {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Consignee)) {
                where += $@" and o.{nameof(RB_Goods_Order.Consignee)} like '%{dmodel.Consignee}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile)) {
                where += $@" and o.{nameof(RB_Goods_Order.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.ProductCode)) {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }
            if (dmodel.Recycled > 0) {
                where += $@" and o.{nameof(RB_Goods_Order.Recycled)}={(int)dmodel.Recycled}";
            }

            string sql = $@"SELECT o.*,u.Name as UserName FROM rb_goods_order o
INNER JOIN rb_goods_orderdetail od on o.OrderId=od.OrderId
INNER JOIN rb_member_user u on o.UserId=u.Id
where {where} group by o.OrderId order by o.CreateDate desc";
            return GetPage<RB_Goods_Order_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 会员购买
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_Extend> GetMembersToBuyPageList(int pageIndex, int pageSize, out long count, RB_Goods_Order_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0";
            where += $@" and u.{nameof(RB_Member_User.MemberGrade)} >0";
            where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(2,3,4,5,6)";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderSource > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderSource)}={(int)dmodel.OrderSource}";
            }
            //if (dmodel.OrderType > 0)
            //{
            //    where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            //}
            if (dmodel.DeliveryMethod > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.DeliveryMethod)}={(int)dmodel.DeliveryMethod}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (dmodel.OrderStatus > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)dmodel.OrderStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.MerchantsNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.MerchantsNo)} like '%{dmodel.MerchantsNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.UserId)}={(int)dmodel.UserId}";
            }
            //if (!string.IsNullOrEmpty(dmodel.GoodsName))
            //{
            //    where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            //}
            if (!string.IsNullOrEmpty(dmodel.Consignee))
            {
                where += $@" and o.{nameof(RB_Goods_Order.Consignee)} like '%{dmodel.Consignee}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $@" and o.{nameof(RB_Goods_Order.Mobile)} like '%{dmodel.Mobile}%'";
            }
            //if (!string.IsNullOrEmpty(dmodel.ProductCode))
            //{
            //    where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            //}
            if (dmodel.Recycled > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.Recycled)}={(int)dmodel.Recycled}";
            }

            string sql = $@"SELECT o.*,u.Name as UserName FROM rb_goods_order o
INNER JOIN rb_member_user u on o.UserId=u.Id
where {where} order by o.CreateDate desc";
            return GetPage<RB_Goods_Order_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 分销订单
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Order_Extend> GetDistributionOrdersPageList(int pageIndex, int pageSize, out long count, RB_Goods_Order_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0";
            where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(1,2,3,4,5,6)";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderSource > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderSource)}={(int)dmodel.OrderSource}";
            }
            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.DeliveryMethod > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.DeliveryMethod)}={(int)dmodel.DeliveryMethod}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (dmodel.OrderStatus > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)dmodel.OrderStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.MerchantsNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.MerchantsNo)} like '%{dmodel.MerchantsNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.UserId)}={(int)dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Consignee))
            {
                where += $@" and o.{nameof(RB_Goods_Order.Consignee)} like '%{dmodel.Consignee}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $@" and o.{nameof(RB_Goods_Order.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }
            if (dmodel.Recycled > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.Recycled)}={(int)dmodel.Recycled}";
            }

            string sql = $@"SELECT o.*,u.Name as UserName FROM rb_goods_order o
INNER JOIN rb_goods_orderdetail od on o.OrderId=od.OrderId
INNER JOIN rb_member_user u on o.UserId=u.Id
where {where} group by o.OrderId order by o.CreateDate desc";
            return GetPage<RB_Goods_Order_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 清空回收站
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetOrderEmptyRecycleBin(int tenantId, int mallBaseId)
        {
            string sql = $" update rb_goods_order set {nameof(RB_Goods_Order.Status)}=1 where {nameof(RB_Goods_Order.Recycled)}=1 " +
                $"and {nameof(RB_Goods_Order.Status)}=0 and {nameof(RB_Goods_Order.TenantId)}={tenantId} and {nameof(RB_Goods_Order.MallBaseId)}={mallBaseId}";
            return Execute(sql) > 0;
        }
    }
}
