﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 门店表仓储层
    /// </summary>
    public class RB_StoresRepository : BaseRepository<RB_Stores>
    {
        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Stores_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            float lng = 0;
            float lat = 0;
            if (!string.IsNullOrEmpty(query.CurrentPosition))
            {
               var tempArray= query.CurrentPosition.Split(',');
                if (tempArray != null && tempArray.Length == 2)
                {
                    float.TryParse(tempArray[0], out lng);
                    float.TryParse(tempArray[1], out lat);
                }
            }
            builder.AppendFormat(@" SELECT * ");
            if (lng > 0 && lat > 0)
            {
                builder.AppendFormat(@",lat_lng_distance(Lng,Lat,{0},{1}) AS KM ",lng,lat);
            }
            builder.AppendFormat(@"
FROM RB_Stores 
WHERE 1 = 1 AND Status = 0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.Id), query.Id);
            }
            if (query.Name!=null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Stores_Extend.Name), query.Name.Trim());
            }

            if (query.OrderByType == 1)
            {
                builder.Append(" ORDER BY Name ASC ");
            }
            else if (query.OrderByType == 2)
            {
                builder.Append(" ORDER BY Name DESC ");
            }
            else if (query.OrderByType == 3)
            {
                if (lng > 0 && lat > 0)
                {
                    builder.AppendFormat(" ORDER BY lat_lng_distance(Lng,Lat,{0},{1}) ASC ", lng, lat);
                }
            }
            else if (query.OrderByType == 4)
            {
                if (lng > 0 && lat > 0)
                {
                    builder.AppendFormat(" ORDER BY lat_lng_distance(Lng,Lat,{0},{1}) DESC ", lng, lat);
                }
            }
            else if (query.OrderByType == 5)
            {
                builder.Append(" ORDER BY Score ASC ");
            }
            else if (query.OrderByType == 6)
            {
                builder.Append(" ORDER BY Score DESC ");
            }
            else
            {
                builder.Append(" ORDER BY Id DESC ");
            }
            return GetPage<RB_Stores_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 门店列表
        /// </summary>
        /// <param name="query"></param>
        /// <param name="isFirst">是否取第一条</param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresListRepository(RB_Stores_Extend query,bool isFirst=false)
        {
            StringBuilder builder = new StringBuilder();
            float lng = 0;
            float lat = 0;
            if (!string.IsNullOrEmpty(query.CurrentPosition))
            {
                var tempArray = query.CurrentPosition.Split(',');
                if (tempArray != null && tempArray.Length == 2)
                {
                    float.TryParse(tempArray[0], out lng);
                    float.TryParse(tempArray[1], out lat);
                }
            }
            builder.AppendFormat(@" SELECT * ");
            if (lng > 0 && lat > 0)
            {
                builder.AppendFormat(@",lat_lng_distance(Lng,Lat,{0},{1}) AS KM ", lng, lat);
            }
            builder.AppendFormat(@"
FROM RB_Stores 
WHERE 1 = 1 AND Status = 0 ");

            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.Id), query.Id);
            }
            if (query.Name != null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Stores_Extend.Name), query.Name.Trim());
            }

            if (query.OrderByType == 1)
            {
                builder.Append(" ORDER BY Name ASC ");
            }
            else if (query.OrderByType == 2)
            {
                builder.Append(" ORDER BY Name DESC ");
            }
            else if (query.OrderByType == 3)
            {
                if (lng > 0 && lat > 0)
                {
                    builder.AppendFormat(" ORDER BY lat_lng_distance(Lng,Lat,{0},{1}) ASC ", lng, lat);
                }
            }
            else if (query.OrderByType == 4)
            {
                if (lng > 0 && lat > 0)
                {
                    builder.AppendFormat(" ORDER BY lat_lng_distance(Lng,Lat,{0},{1}) DESC ", lng, lat);
                }
            }
            else if (query.OrderByType == 5)
            {
                builder.Append(" ORDER BY Score ASC ");
            }
            else if (query.OrderByType == 6)
            {
                builder.Append(" ORDER BY Score DESC ");
            }
            else
            {
                builder.Append(" ORDER BY Id DESC ");
            }

            if (isFirst)
            {
                builder.Append(" LIMIT 1; ");
            }
            return Get<RB_Stores_Extend>(builder.ToString()).ToList();
        }
    }
}