﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();

        #region 联系人管理

        /// <summary>
        /// 获取联系人分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetContractPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Contract_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult SetContract()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Contract_Extend>(RequestParm.msg.ToString());
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            var flag = module.SetContractModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = module.GetContractModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = module.RemoveContractModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_InvestmentProcurement_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改投资采购
        /// </summary>
        /// <returns></returns>
        public ApiResult SetInvestmentProcurement()
        {
            var extModel = JsonConvert.DeserializeObject<RB_InvestmentProcurement_Extend>(RequestParm.msg.ToString());
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = procurementModule.SetInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除投资采购信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = procurementModule.RemoveInvestmentProcurementModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 公司信息管理

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompanyPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Company_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = companyModule.GetCompanyPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCompany()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Company_Extend>(RequestParm.msg.ToString());
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = companyModule.SetCompanyModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取公司信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var extModel = companyModule.GetCompanyModule(CompanyId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = companyModule.RemoveCompanyModule(CompanyId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}
