﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.WeChat.Common
{
    /// <summary>
    /// 微信事件接受的类
    /// </summary>
    public class WechatMessage
    {



        /// <summary>
        /// appid
        /// </summary>
        public string AppId { get; set; }

        /// <summary>
        /// Token 
        /// </summary>
        public string Token { get; set; }

        /// <summary>
        /// EncodingAESKey 
        /// </summary>
        public string EncodingAESKey { get; set; }

        /// <summary>
        /// 本公众帐号
        /// </summary>
        public string ToUserName { get; set; }
        /// <summary>
        /// 用户帐号
        /// </summary>
        public string FromUserName { get; set; }
        /// <summary>
        /// 发送时间戳
        /// </summary>
        public string CreateTime { get; set; }
        /// <summary>
        /// 发送的文本内容 
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 消息的类型
        /// </summary>
        public string MsgType { get; set; }
        /// <summary>
        /// 事件类型，subscribe(订阅)、unsubscribe(取消订阅)、scan（二维码扫描事件）、location（上报地理位置事件）、click（菜单点击事件）
        /// </summary>
        public string EventName { get; set; }

        

        /// <summary>
        /// 消息id
        /// </summary>
        public string MsgId { get; set; }


        /// <summary>
        /// 消息标题
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 消息url地址
        /// </summary>
        public string PagePath { get; set; }


        
    }
}
