﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Point
{

    /// <summary>
    /// 点数产品
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Point_Goods
    {
        public int ID { get; set; }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }

        /// <summary>
        /// 售价
        /// </summary>        
        public decimal? SellingPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 原价
        /// </summary>        
        public decimal? OriginalPrice
        {
            get;
            set;
        }

        /// <summary>
        /// 成本价格
        /// </summary>        
        public decimal? CostPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 点数
        /// </summary>
        public int PonitNum { get; set; }
        /// <summary>
        /// 赠送点数 0-不赠送，>0赠送
        /// </summary>
        public int GivePoint { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string GoodsName { get; set; }



        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? State
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

    }
}
