﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 品牌分类实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_BrandClass
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
      

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }


        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }


        /// <summary>
        /// logo
        /// </summary>
        public string Logo { get; set; }


        /// <summary>
        /// 分类名称
        /// </summary>
        public string ClassName { get; set; }

     
    }
}
