﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Point;
using Mall.Model.Entity.Point;

namespace Mall.Model.Extend.Point
{
    public class RB_Point_TeacherCourse_Extend : RB_Point_TeacherCourse
    {

        /// <summary>
        /// 分类类型
        /// </summary>
        public CourseClassTypeEnum CourseClassType { get; set; }


        /// <summary>
        /// 上课人数
        /// </summary>
        public StudentNumTypeEnum StudentNumType { get; set; }


        /// <summary>
        /// 分类名称
        /// </summary>
        public string ClassName { get; set; }


        /// <summary>
        /// 学生人数名称
        /// </summary>
        public string StudentNumTypeName { get; set; }



        /// <summary>
        /// 时长名称
        /// </summary>
        public string DurationUnitName { get; set; }

        /// <summary>
        /// 是否为公开课0-否，1-是
        /// </summary>
        public int IsPublic { get; set; }


        /// <summary>
        /// 是否免费0-否，1-是
        /// </summary>
        public int IsFree { get; set; }

        /// <summary>
        /// 确认数量
        /// </summary>
        public int ConfirmNum { get; set; }

        /// <summary>
        /// 课程状态  1未上课   2已上课
        /// </summary>
        public int CourseStudyState { get; set; }

        /// <summary>
        /// 学习开始时间
        /// </summary>
        public DateTime StudyStartTime { get; set; }


        /// <summary>
        /// 学习结束时间
        /// </summary>
        public DateTime StudyEndTime { get; set; }


        public string TeacherName { get; set; }


        public string TeacherLogo { get; set; }


        #region 查询时间范围
        /// <summary>
        /// 查询开始时间
        /// </summary>
        public string SelectStartTime { get; set; }


        /// <summary>
        /// 查询结束时间
        /// </summary>
        public string SelectEndTime { get; set; }

        /// <summary>
        /// 订单数
        /// </summary>
        public int OrderNum { get; set; }
        #endregion
    }
}
