﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动评论表仓储层
    /// </summary>
    public class RB_Commerce_CommentRepository:BaseRepository<RB_Commerce_Comment>
    {
        /// <summary>
        /// 获取活动评论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Comment_Extend> GetCommerceCommentPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Comment_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_commerce_comment
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Comment_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Comment_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Comment_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Comment_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Content))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_Comment_Extend.Content));
                    parameters.Add("Name", "%" + query.Content.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Comment_Extend.ActivityId), query.ActivityId);
                }
            }
            return GetPage<RB_Commerce_Comment_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    
    }
}