﻿using Newtonsoft.Json.Linq;
using Test.Model;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using Test.DBHelper;
using System.Linq;

namespace Test.Helper
{
    /// <summary>
    /// 订单帮助类
    /// </summary>
    public class OrderHelper
    {

        /// <summary>
        /// 获取数据
        /// </summary>
        /// <param name="cookie"></param>
        public static void GetUserData()
        {
            string cookie = "";
            int pageIndex = 1;
            int pageCount = 2;
            while (pageIndex <= pageCount)
            {
                var tempImgList = GetUserImgList(cookie, pageIndex, out pageCount);
                Console.WriteLine(pageIndex + "/" + pageCount + " Edd");
                if (tempImgList != null && tempImgList.Any())
                {
                    foreach (var subItem in tempImgList)
                    {
                        if (subItem.user_id >= 19992 && subItem.user_id <= 101706)
                        {
                            StringBuilder stringBuilder = new StringBuilder();
                            //stringBuilder.AppendFormat("update rb_member_user set Photo = '{0}',Name='{1}',SuperiorId={2} where Id = {3}", subItem.avatar, subItem.nickname, subItem.parent_id, subItem.user_id);
                            stringBuilder.AppendFormat("update rb_member_user set SuperiorId={0} where Id = {1} and SuperiorId not in (5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)", subItem.parent_id, subItem.user_id);
                            try
                            {
                                var newResult = MySqlHelper.ExecuteNonQuery(MySqlHelper.defaultConnection, System.Data.CommandType.Text, stringBuilder.ToString(), null);
                                //Console.WriteLine("请求:" + subItem.avatar + "    " + subItem.nickname + "    " + subItem.parent_id);
                            }
                            catch (Exception ex)
                            {
                                Console.WriteLine("失败UserId:" + subItem.user_id + " Msg:" + ex.Message);
                            }
                        }
                    }
                }
                pageIndex++;
                var ranDomNum = new Random().Next(3, 7);
                Thread.Sleep(1000 * ranDomNum);
            }
        }

        /// <summary>
        /// 获取订单列表
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="pageIndex"></param>
        /// <param name="pageCount"></param>
        /// <returns></returns>
        static List<UserImage> GetOrderList(string cookie, int pageIndex, out int pageCount)
        {
            pageCount = 2;
            List<UserImage> list = new List<UserImage>();
            string newImaApi = "http://wx.weibaoge.cn/web/index.php?r=mall%2Forder%2Findex&keyword=&keyword_1=1&date_start=&date_end=&platform=&status=-1&plugin=all&send_type=-1&type=&page=" + pageIndex;
            cookie = "__login_route=%2Fadmin%2Fpassport%2Flogin; __login_role=admin; HJ_SESSION_ID=lgfv5vck57rj84nh4npn59b4pj; _csrf=1febe37678187521a164220da9a9293f67d6d638a1cc01acebf0d3123757216ea%3A2%3A%7Bi%3A0%3Bs%3A5%3A%22_csrf%22%3Bi%3A1%3Bs%3A32%3A%22e5vd7mYVeGAfqcBMV_m0lkeiJLXFghtc%22%3B%7D";
            string jsonData = HttpGet(newImaApi, cookie);
            
            if (jsonData != null && !string.IsNullOrEmpty(jsonData))
            {
                JObject obj = JObject.Parse(jsonData);
                JObject dataObj = JObject.Parse(obj["data"].ToString());
                list = Newtonsoft.Json.JsonConvert.DeserializeObject<List<UserImage>>(dataObj["list"].ToString());

                var pageObj = JObject.Parse(dataObj["pagination"].ToString());
                Int32.TryParse(pageObj["page_count"].ToString(), out pageCount);
            }
            return list;
        }

        /// <summary>
        /// Get获取数据
        /// </summary>
        /// <param name="url">url地址</param>
        /// <param name="encode">编码方式</param>
        /// <param name="Source">来源</param>
        /// <returns></returns>
        static string HttpGet(string url, string cookie)
        {
            HttpWebRequest myRequest = (HttpWebRequest)WebRequest.Create(url);
            myRequest.Headers.Add("Cookie", cookie);
            myRequest.Headers.Add("X-Requested-With", "XMLHttpRequest");
            myRequest.Method = "GET";
                
            HttpWebResponse myResponse = (HttpWebResponse)myRequest.GetResponse();
            StreamReader reader = new StreamReader(myResponse.GetResponseStream(), Encoding.UTF8);
            string content = reader.ReadToEnd();
            reader.Close();
            return content;
        }

        /// <summary>
        /// Get获取数据
        /// </summary>
        /// <param name="url">url地址</param>
        /// <param name="encode">编码方式</param>
        /// <param name="Source">来源</param>
        /// <returns></returns>
        public static string HttpGet(string url, Encoding encode, string Source, string cookie = "")
        {
            HttpWebRequest myRequest = (HttpWebRequest)WebRequest.Create(url);
            if (!string.IsNullOrEmpty(Source))
            {
                myRequest.Referer = Source;
            }
            if (!string.IsNullOrEmpty(cookie))
            {
                myRequest.Headers.Add("cookie", cookie);
            }
            myRequest.Method = "GET";
            HttpWebResponse myResponse = null;
            try
            {
                myResponse = (HttpWebResponse)myRequest.GetResponse();
                StreamReader reader = new StreamReader(myResponse.GetResponseStream(), encode);
                string content = reader.ReadToEnd();
                return content;
            }
            //异常请求  
            catch (WebException e)
            {
                myResponse = (HttpWebResponse)e.Response;
                using (Stream errData = myResponse.GetResponseStream())
                {
                    using (StreamReader reader = new StreamReader(errData))
                    {
                        string text = reader.ReadToEnd();
                        return text;
                    }
                }
            }
        }

    }
}
