﻿using Mall.CacheManager.AppletWeChat;
using Mall.CacheManager.DataStatistic;
using Mall.Common.Enum;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.User;
using Mall.Repository.TradePavilion;
using MongoDB.Bson.IO;
using Newtonsoft.Json.Linq;
using RabbitMQ.Client.Framing.Impl;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;
using VT.FW.DB.Dapper;
using static ICSharpCode.SharpZipLib.Zip.ExtendedUnixData;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 宜宾商载通新方法处理类
    /// </summary>
    public partial class BuildingCarrierModule
    {
        /// <summary>
        /// 【商载通】楼宇、载体仓储层
        /// </summary>
        private readonly RB_Building_CarrierRepository building_CarrierRepository = new RB_Building_CarrierRepository();
        /// <summary>
        /// 【商载通】楼宇、载体地铁仓储层
        /// </summary>
        private readonly RB_Building_CarriermetroRepository building_CarriermetroRepository = new RB_Building_CarriermetroRepository();

        /// <summary>
        /// 【商载通】 品牌、企业服务仓储层
        /// </summary>
        private readonly RB_Brand_EnterpriseRepository brand_EnterpriseRepository = new RB_Brand_EnterpriseRepository();
        /// <summary>
        /// 品牌分类信息仓储层对象
        /// </summary>
        private readonly RB_BrandClassRepository brandClassRepository = new RB_BrandClassRepository();


        /// <summary>
        /// 品牌分类信息仓储层对象
        /// </summary>
        private readonly RB_Visit_LogRepository visit_LogRepository = new RB_Visit_LogRepository();

        /// <summary>
        /// 活力楼宇仓储层
        /// </summary>
        private readonly RB_BuildingRepository buildingRepository = new RB_BuildingRepository();

        /// <summary>
        /// 企业服务仓储层
        /// </summary>
        private readonly RB_EnterpriseServicesRepository enterpriseServicesRepository = new RB_EnterpriseServicesRepository();

        /// <summary>
        /// 获取载体、楼宇分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Building_Carrier_Extend query)
        {
            var list = building_CarrierRepository.GetBuildingCarrierPageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.ID));
                List<RB_Building_Carriermetro_Extend> metroList = new List<RB_Building_Carriermetro_Extend>();
                if (!string.IsNullOrEmpty(Ids))
                {
                    metroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend() { CarrierIds = Ids });
                }
                foreach (var item in list)
                {
                    item.BannerList = new List<string>();
                    if (!string.IsNullOrWhiteSpace(item.Banner))
                    {
                        item.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(item.Banner);
                    }
                    item.BuildingCarriermetroList = metroList.Where(qitem => qitem.CarrierId == item.ID)?.ToList() ?? new List<RB_Building_Carriermetro_Extend>();
                }
            }
            return list;
        }

        /// <summary>
        /// 获取载体楼宇列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierListModule(RB_Building_Carrier_Extend query)
        {
            var list = building_CarrierRepository.GetBuildingCarrierListRepository(query);

            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.ID));
                List<RB_Building_Carriermetro_Extend> metroList = new List<RB_Building_Carriermetro_Extend>();
                if (!string.IsNullOrEmpty(Ids))
                {
                    metroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend() { CarrierIds = Ids });
                }
                foreach (var item in list)
                {
                    item.BuildingCarriermetroList = metroList.Where(qitem => qitem.CarrierId == item.ID)?.ToList() ?? new List<RB_Building_Carriermetro_Extend>();
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改载体、楼宇
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetBuildingCarrierModule(RB_Building_Carrier_Extend extModel)
        {
            bool flag;
            if (extModel.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Building_Carrier_Extend.CarrierName),extModel.CarrierName },
                    {nameof(RB_Building_Carrier_Extend.Logo),extModel.Logo },
                    {nameof(RB_Building_Carrier_Extend.Banner),extModel.Banner },
                    {nameof(RB_Building_Carrier_Extend.Honor),extModel.Honor },
                    {nameof(RB_Building_Carrier_Extend.Developers),extModel.Developers },
                    {nameof(RB_Building_Carrier_Extend.OpeningStatus),extModel.OpeningStatus },
                    {nameof(RB_Building_Carrier_Extend.VideoUrl),extModel.VideoUrl },
                    {nameof(RB_Building_Carrier_Extend.Address),extModel.Address },
                    {nameof(RB_Building_Carrier_Extend.LatAndLon),extModel.LatAndLon },
                    {nameof(RB_Building_Carrier_Extend.OpenTime),extModel.OpenTime },
                    {nameof(RB_Building_Carrier_Extend.BuildingCarrierType),extModel.BuildingCarrierType },
                    {nameof(RB_Building_Carrier_Extend.CategoryId),extModel.CategoryId },
                    {nameof(RB_Building_Carrier_Extend.Ascription),extModel.Ascription },
                    {nameof(RB_Building_Carrier_Extend.CarrierSize),extModel.CarrierSize },
                    {nameof(RB_Building_Carrier_Extend.PropertyComposition),extModel.PropertyComposition },
                    {nameof(RB_Building_Carrier_Extend.Location),extModel.Location },
                    {nameof(RB_Building_Carrier_Extend.Crowd),extModel.Crowd },
                    {nameof(RB_Building_Carrier_Extend.VisitorsFlowrate),extModel.VisitorsFlowrate },
                    {nameof(RB_Building_Carrier_Extend.LayersNum),extModel.LayersNum },
                    {nameof(RB_Building_Carrier_Extend.SupportingFacilities),extModel.SupportingFacilities },
                    {nameof(RB_Building_Carrier_Extend.ManagementCompany),extModel.ManagementCompany },
                    {nameof(RB_Building_Carrier_Extend.BrandDemand),extModel.BrandDemand },
                    {nameof(RB_Building_Carrier_Extend.UpdateBy),extModel.UpdateBy },
                    {nameof(RB_Building_Carrier_Extend.UpdateDate),extModel.UpdateDate },

                    //新增参数
                    {nameof(RB_Building_Carrier_Extend.CarNum),extModel.CarNum },
                    {nameof(RB_Building_Carrier_Extend.BuiltUpArea),extModel.BuiltUpArea },
                    {nameof(RB_Building_Carrier_Extend.AreaRequirement),extModel.AreaRequirement },
                    {nameof(RB_Building_Carrier_Extend.CarrierPlan),extModel.CarrierPlan },
                    {nameof(RB_Building_Carrier_Extend.ContactName),extModel.ContactName },
                    {nameof(RB_Building_Carrier_Extend.ContactPhone),extModel.ContactPhone },
                };
                flag = building_CarrierRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), extModel.ID));
            }
            else
            {
                var newId = building_CarrierRepository.Insert(extModel);
                extModel.ID = newId;
                flag = newId > 0;
            }

            if (flag)
            {
                var oldCarrierMetroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend { TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId, CarrierId = extModel.ID });
                building_CarriermetroRepository.DeleteBatch(oldCarrierMetroList);
                foreach (var item in extModel.BuildingCarriermetroList)
                {
                    item.ID = 0;
                    item.Status = 0;
                    item.TenantId = extModel.TenantId;
                    item.MallBaseId = extModel.MallBaseId;
                    item.CarrierId = extModel.ID;
                }
                building_CarriermetroRepository.InsertBatch(extModel.BuildingCarriermetroList);
            }
            return flag;
        }

        /// <summary>
        /// 删除载体、楼宇
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public bool RemoveBuildingCarrierModule(int ID)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Building_Carrier_Extend.Status),(int)DateStateEnum.Delete },
                {nameof(RB_Building_Carrier_Extend.UpdateDate),DateTime.Now }
            };
            bool flag = building_CarrierRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Carrier_Extend.ID), ID));
            return flag;
        }



        /// <summary>
        /// 验证载体名称
        /// </summary>
        /// <param name="carrierName"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateBuildingCarrierName(string carrierName, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Building_Carrier_Extend.CarrierName),
                      FiledValue=carrierName,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName=nameof(RB_Building_Carrier_Extend.MallBaseId),
                      FiledValue=mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return building_CarrierRepository.Exists(wheres);
        }

        /// <summary>
        /// 根据编号获取载体、楼宇详情
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public RB_Building_Carrier_Extend GetBuildingCarrierModule(int ID, bool isVisit = false)
        {
            var extModel = building_CarrierRepository.GetEntity<RB_Building_Carrier_Extend>(ID);
            if (extModel != null && extModel.CategoryId > 0)
            {
                extModel.CategoryName = brandClassRepository.GetEntity(extModel.CategoryId)?.ClassName ?? "";
            }
            if (extModel != null && extModel.ID > 0)
            {
                var bcMetroList = building_CarriermetroRepository.GetBuildingCarrierMetroListRepository(new RB_Building_Carriermetro_Extend() { CarrierId = extModel.ID });
                extModel.BuildingCarriermetroList = bcMetroList ?? new List<RB_Building_Carriermetro_Extend>();
                extModel.BannerList = new List<string>();
                if (!string.IsNullOrWhiteSpace(extModel.Banner))
                {
                    extModel.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
                }

                extModel.HonorList = new List<string>();
                if (!string.IsNullOrWhiteSpace(extModel.Honor))
                {
                    extModel.HonorList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(extModel.Honor);
                }
            }
            if ((extModel?.ID ?? 0) > 0 && isVisit)
            {
                System.Threading.Tasks.Task.Run(() => visit_LogRepository.AddVisitLog(extModel.TenantId, extModel.MallBaseId, extModel.ID, 1));
            }
            return extModel;
        }

        /// <summary>
        /// 【商载通】品牌、企业服务仓储层
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetBrandEnterprisePageModule(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Enterprise_Extend query)
        {
            var list = brand_EnterpriseRepository.GetBrandEnterprisePageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Any())
            {
                foreach (var item in list)
                {
                    item.BannerList = new List<string>();
                    if (!string.IsNullOrWhiteSpace(item.Banner))
                    {
                        item.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(item.Banner);
                    }
                }
            }
            return list;
        }


        /// <summary>
        /// 【商载通】品牌、企业服务仓储层
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetBrandEnterpriseListModule(RB_Brand_Enterprise_Extend query)
        {
            return brand_EnterpriseRepository.GetBrandEnterpriseListRepository(query);
        }

        /// <summary>
        /// 新增修改品牌和企业服务
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBrandEnterpriseModule(RB_Brand_Enterprise_Extend model)
        {
            bool flag;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Brand_Enterprise_Extend.BrandName),model.BrandName},
                    { nameof(RB_Brand_Enterprise_Extend.FullBrandName),model.FullBrandName},
                    { nameof(RB_Brand_Enterprise_Extend.VideoUrl),model.VideoUrl},
                    { nameof(RB_Brand_Enterprise_Extend.Logo),model.Logo},
                    { nameof(RB_Brand_Enterprise_Extend.Banner),model.Banner},
                    { nameof(RB_Brand_Enterprise_Extend.ShopNum),model.ShopNum},
                    { nameof(RB_Brand_Enterprise_Extend.BuiltUpArea),model.BuiltUpArea},
                    { nameof(RB_Brand_Enterprise_Extend.EndBuiltUpArea),model.EndBuiltUpArea},
                    { nameof(RB_Brand_Enterprise_Extend.BrandType),model.BrandType},
                    { nameof(RB_Brand_Enterprise_Extend.CustomerType),model.CustomerType},
                    { nameof(RB_Brand_Enterprise_Extend.AreaRequirement),model.AreaRequirement},
                    { nameof(RB_Brand_Enterprise_Extend.EndAreaRequirement),model.EndAreaRequirement},
                    { nameof(RB_Brand_Enterprise_Extend.CategoryId),model.CategoryId},
                    { nameof(RB_Brand_Enterprise_Extend.BrandEnterpriseType),model.BrandEnterpriseType},
                    { nameof(RB_Brand_Enterprise_Extend.Introduce),model.Introduce},
                    { nameof(RB_Brand_Enterprise_Extend.DevIntention),model.DevIntention},
                    { nameof(RB_Brand_Enterprise_Extend.PropertyDemand),model.PropertyDemand},
                    { nameof(RB_Brand_Enterprise_Extend.Cooperation),model.Cooperation},
                    { nameof(RB_Brand_Enterprise_Extend.Complementary),model.Complementary},
                    { nameof(RB_Brand_Enterprise_Extend.ContactName),model.ContactName},
                    { nameof(RB_Brand_Enterprise_Extend.ContactPhone),model.ContactPhone},
                };
                flag = brand_EnterpriseRepository.Update(fileds, new WhereHelper(nameof(RB_Brand_Enterprise_Extend.ID), model.ID));
            }
            else
            {
                var newId = brand_EnterpriseRepository.Insert(model);
                model.ID = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取品牌和企业服务
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public RB_Brand_Enterprise_Extend GetBrandEnterpriseModule(int ID, bool isVisit = false)
        {
            var extModel = brand_EnterpriseRepository.GetEntity<RB_Brand_Enterprise_Extend>(ID);
            if (extModel != null && extModel.CategoryId > 0)
            {
                extModel.CategoryName = brandClassRepository.GetEntity(extModel.CategoryId)?.ClassName ?? "";

            }
            extModel.BannerList = new List<string>();
            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            if ((extModel?.ID ?? 0) > 0 && isVisit)
            {
                System.Threading.Tasks.Task.Run(() => visit_LogRepository.AddVisitLog(extModel.TenantId, extModel.MallBaseId, extModel.ID, 3));
            }
            return extModel;
        }

        /// <summary>
        /// 根据编号删除品牌和企业服务
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public bool RemoveBrandEnterpriseModule(int ID)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Brand_Enterprise_Extend.Status), (int)DateStateEnum.Delete},
                {nameof(RB_Brand_Enterprise_Extend.UpdateDate),DateTime.Now },
            };
            bool flag = brand_EnterpriseRepository.Update(fileds, new WhereHelper(nameof(RB_Brand_Enterprise_Extend.ID), ID));
            return flag;
        }


        #region 活力楼宇

        /// <summary>
        /// 获取活力楼宇分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Extend> GetBuildingPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Building_Extend query)
        {
            var list = buildingRepository.GetBuildingPageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Any())
            {
                foreach (var item in list)
                {

                    item.BannerList = new List<string>();
                    if (!string.IsNullOrWhiteSpace(item.Banner))
                    {
                        item.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(item.Banner);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改活力楼宇
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBuildingModule(RB_Building_Extend model)
        {
            bool flag;
            if (model.BuildId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Building_Extend.Name),model.Name},
                    { nameof(RB_Building_Extend.Banner),model.Banner},
                    { nameof(RB_Building_Extend.Address),model.Address},
                    { nameof(RB_Building_Extend.LatAndLon),model.LatAndLon},
                    { nameof(RB_Building_Extend.OperationTime),model.OperationTime},
                    { nameof(RB_Building_Extend.CategoryId),model.CategoryId},
                    { nameof(RB_Building_Extend.Areas),model.Areas},
                    { nameof(RB_Building_Extend.BuildingNum),model.BuildingNum},
                    { nameof(RB_Building_Extend.FloorNum),model.FloorNum},
                    { nameof(RB_Building_Extend.ElevatorNum),model.ElevatorNum},
                    { nameof(RB_Building_Extend.FloorHeight),model.FloorHeight},
                    { nameof(RB_Building_Extend.Developers),model.Developers},
                    { nameof(RB_Building_Extend.PropertyComp),model.PropertyComp},
                    { nameof(RB_Building_Extend.SaleOrSelf),model.SaleOrSelf},
                    { nameof(RB_Building_Extend.IsAllOperate),model.IsAllOperate},
                    { nameof(RB_Building_Extend.ConstructionTime),model.ConstructionTime},
                    { nameof(RB_Building_Extend.PropertyFee),model.PropertyFee},
                    { nameof(RB_Building_Extend.RentFee),model.RentFee},
                    { nameof(RB_Building_Extend.IndustryDirection),model.IndustryDirection},
                    { nameof(RB_Building_Extend.BrandDemand),model.BrandDemand},
                    { nameof(RB_Building_Extend.Other),model.Other},
                    { nameof(RB_Building_Extend.ContactName),model.ContactName},
                    { nameof(RB_Building_Extend.ContactPhone),model.ContactPhone},
                    { nameof(RB_Building_Extend.UpdateBy),model.UpdateBy},
                    { nameof(RB_Building_Extend.UpdateDate),model.UpdateDate},
                };
                flag = buildingRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Extend.BuildId), model.BuildId));
            }
            else
            {
                var newId = buildingRepository.Insert(model);
                model.BuildId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取活力楼宇详情
        /// </summary>
        /// <param name="BuildId"></param>
        /// <returns></returns>
        public RB_Building_Extend GetBuildingInfoModule(int BuildId, bool isVisit = false)
        {
            var extModel = buildingRepository.GetEntity<RB_Building_Extend>(BuildId);
            if (extModel != null && extModel.CategoryId > 0)
            {
                extModel.CategoryName = brandClassRepository.GetEntity(extModel.CategoryId)?.ClassName ?? "";
            }
            if (!string.IsNullOrWhiteSpace(extModel?.Banner ?? ""))
            {
                extModel.BannerList = new List<string>();
                extModel.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            if ((extModel?.BuildId ?? 0) > 0 && isVisit)
            {
                System.Threading.Tasks.Task.Run(() => visit_LogRepository.AddVisitLog(extModel.TenantId, extModel.MallBaseId, extModel.BuildId, 2));
            }
            return extModel;
        }



        /// <summary>
        /// 根据编号删除获取楼宇
        /// </summary>
        /// <param name="BuildId"></param>
        /// <returns></returns>
        public bool RemoveBuildingModule(int BuildId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Building_Extend.Status),(int)DateStateEnum.Delete },
                {nameof(RB_Building_Extend.UpdateDate),DateTime.Now }
            };
            bool flag = buildingRepository.Update(fileds, new WhereHelper(nameof(RB_Building_Extend.BuildId), BuildId));
            return flag;
        }

        #endregion

        #region 企业服务

        /// <summary>
        /// 获取企业服务分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_EnterpriseServices_Extend> GetEnterpriseServicesPageModule(int pageIndex, int pageSize, out long rowsCount, RB_EnterpriseServices_Extend query)
        {
            var list = enterpriseServicesRepository.GetEnterpriseServicesPageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list!=null&&list.Any())
            {
                foreach (var item in list)
                {
                    item.BannerList = new List<string>();
                    if (!string.IsNullOrWhiteSpace(item?.Banner ?? ""))
                    {
                        item.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(item.Banner);
                    }
                }
                
            }
            return list;
        }

        /// <summary>
        /// 新增修改企业服务
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetEnterpriseServicesModule(RB_EnterpriseServices_Extend model)
        {
            bool flag = false;
            if (model.ServiceId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_EnterpriseServices_Extend.Name),model.Name},
                    { nameof(RB_EnterpriseServices_Extend.Banner),model.Banner},
                    { nameof(RB_EnterpriseServices_Extend.Introduction),model.Introduction},
                    { nameof(RB_EnterpriseServices_Extend.DevIntention),model.DevIntention},
                    { nameof(RB_EnterpriseServices_Extend.Address),model.Address},
                    { nameof(RB_EnterpriseServices_Extend.LatAndLon),model.LatAndLon},
                    { nameof(RB_EnterpriseServices_Extend.OperationTime),model.OperationTime},
                    { nameof(RB_EnterpriseServices_Extend.CategoryId),model.CategoryId},
                    { nameof(RB_EnterpriseServices_Extend.Renovation),model.Renovation},
                    { nameof(RB_EnterpriseServices_Extend.Payment),model.Payment},
                    { nameof(RB_EnterpriseServices_Extend.HandoverDate),model.HandoverDate},
                    { nameof(RB_EnterpriseServices_Extend.IntentionalFloor),model.IntentionalFloor},
                    { nameof(RB_EnterpriseServices_Extend.ElevatorNum),model.ElevatorNum},
                    { nameof(RB_EnterpriseServices_Extend.PropertyFee),model.PropertyFee},
                    { nameof(RB_EnterpriseServices_Extend.RentFee),model.RentFee},
                    { nameof(RB_EnterpriseServices_Extend.ContactName),model.ContactName},
                    { nameof(RB_EnterpriseServices_Extend.ContactPhone),model.ContactPhone},
                    { nameof(RB_EnterpriseServices_Extend.UpdateBy),model.UpdateBy},
                    { nameof(RB_EnterpriseServices_Extend.UpdateDate),model.UpdateDate},
                    { nameof(RB_EnterpriseServices_Extend.EType),model.EType},
                };
                flag = enterpriseServicesRepository.Update(fileds, new WhereHelper(nameof(RB_EnterpriseServices_Extend.ServiceId), model.ServiceId));
            }
            else
            {
                var newId = enterpriseServicesRepository.Insert(model);
                model.ServiceId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取企业服务详情
        /// </summary>
        /// <param name="ServiceId"></param>
        /// <returns></returns>
        public RB_EnterpriseServices_Extend GetEnterpriseServicesInfoModule(int ServiceId, bool isVisit = false)
        {
            var extModel = enterpriseServicesRepository.GetEntity<RB_EnterpriseServices_Extend>(ServiceId);
            if (extModel != null)
            {
                if (extModel.CategoryId > 0)
                {
                    extModel.CategoryName = brandClassRepository.GetEntity(extModel.CategoryId)?.ClassName ?? "";
                }
                if (extModel.EType > 0)
                {
                    extModel.ETypeName = brandClassRepository.GetEntity(extModel.EType)?.ClassName ?? "";
                }
            }
            extModel.BannerList = new List<string>();
            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = Newtonsoft.Json.JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            if ((extModel?.ServiceId ?? 0) > 0 && isVisit)
            {
                System.Threading.Tasks.Task.Run(() => visit_LogRepository.AddVisitLog(extModel.TenantId, extModel.MallBaseId, extModel.ServiceId, 4));
            }
            return extModel;
        }

        /// <summary>
        /// 根据编号删除企业服务
        /// </summary>
        /// <param name="ServiceId"></param>
        /// <returns></returns>
        public bool RemoveEnterpriseServicesModule(int ServiceId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_EnterpriseServices_Extend.Status), (int)DateStateEnum.Delete},
                {nameof(RB_EnterpriseServices_Extend.UpdateDate), DateTime.Now}
            };
            bool flag = enterpriseServicesRepository.Update(fileds, new WhereHelper(nameof(RB_EnterpriseServices_Extend.ServiceId), ServiceId));
            return flag;
        }
        #endregion
    }
}
