﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 电子面单实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_ElectronicSheet
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }

        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 发件人姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 发件人电话
        /// </summary>
        public string Mobile { get; set; }


        /// <summary>
        /// 地址
        /// </summary>
        public string Address { get; set; }
        /// <summary>
        /// 0-否1-是
        /// </summary>
        public int IsDefault { get; set; }

        /// <summary>
        /// 省
        /// </summary>
        public int ProvinceId { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public int CityId { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public int DistrictId { get; set; }

        /// <summary>
        /// 发件人手机
        /// </summary>
        public string Phone { get; set; }

        /// <summary>
        /// 发件人邮箱
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// 发件人公司
        /// </summary>
        public string Company { get; set; }
        /// <summary>
        /// 网点名称
        /// </summary>
        public string WebDot { get; set; }

        /// <summary>
        /// 网点编码
        /// </summary>
        public string WebCode { get; set; }

        /// <summary>
        /// 月结编码
        /// </summary>
        public string MonthlyCode { get; set; }

        /// <summary>
        /// 电子面单密码
        /// </summary>
        public string Password { get; set; }

        /// <summary>
        /// 电子面单账号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// 是否打印商品，0-否，1是
        /// </summary>
        public int IsPrintGoods { get; set; }

        /// <summary>
        /// 是否订阅手短信，0-否，1是
        /// </summary>
        public int IsSubscribeSMS { get; set; }

        /// <summary>
        /// 快递公司Id
        /// </summary>
        public int ExpressId { get; set; }
    }
}
