﻿using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 访问记录仓储层
    /// </summary>
    public class RB_Visit_LogRepository : BaseRepository<RB_Visit_Log>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Visit_Log); } }


        /// <summary>
        /// 获取访问记录信息
        /// </summary>
        /// <param name="query"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public List<RB_Visit_Log> GetList(RB_Visit_Log query, string startTime = "", string endTime = "")
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Visit_Log.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Visit_Log.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(startTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Visit_Log.CreateDate)},'%Y-%m-%d' )>=DATE_FORMAT('{startTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(endTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Visit_Log.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{endTime}','%Y-%m-%d' ) ");
                }
            }
            builder.Append($" order by Id desc");
            return Get<RB_Visit_Log>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取访问记录信息
        /// </summary>
        /// <param name="query"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public List<RB_Visit_Log_Extend> GetTopStatisticsList(RB_Visit_Log_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * from ( SELECT ProductType,ProductID,Count(ID) as TotalNum FROM {TableName} WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Visit_Log_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Visit_Log_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ProductType > 0)
                {
                    builder.Append($" AND {nameof(RB_Visit_Log_Extend.ProductType)}={query.ProductType}");
                }
                if (!string.IsNullOrWhiteSpace(query.startDate))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Visit_Log_Extend.CreateDate)},'%Y-%m-%d' )>=DATE_FORMAT('{query.startDate}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.endDate))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_Visit_Log_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{query.endDate}','%Y-%m-%d' ) ");
                }
            }
            builder.Append($" GROUP BY ProductType,ProductID ) as t ORDER BY t.TotalNum desc ");
            if (query.SelectTopNum>0)
            {
                builder.Append($"  LIMIT {query.SelectTopNum} ");
            }
            return Get<RB_Visit_Log_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 新增访问记录
        /// </summary>
        /// <param name="TenantId"></param>
        /// <param name="MallBaseId"></param>
        /// <param name="ProductID">产品id</param>
        /// <param name="ProductType">1-访问载体,2-访问楼宇，3-访问品牌，4-访问企业</param>
        /// <returns></returns>
        public bool AddVisitLog(int TenantId, int MallBaseId, int ProductID, int ProductType)
        {
            RB_Visit_Log model = new RB_Visit_Log
            {
                TenantId = TenantId,
                MallBaseId = MallBaseId,
                ProductID = ProductID,
                ProductType = ProductType,
                CreateDate = DateTime.Now,
            };
            return Insert(model) > 0;
        }
    }
}
