﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.TradePavilion
{
    public enum CarrierExportEnum
    {
        /// <summary>
        /// 项目名称
        /// </summary>
        [EnumField("项目名称")]
        CarrierName = 1,
        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 2,

        /// <summary>
        /// 开发商
        /// </summary>
        [EnumField("开发商")]
        Developers = 3,
        /// <summary>
        /// 载体视频
        /// </summary>
        [EnumField("载体视频")]
        VideoUrl = 4,
        /// <summary>
        /// 项目地址
        /// </summary>
        [EnumField("项目地址")]
        Address = 5,
        /// <summary>
        /// 开业时间
        /// </summary>
        [EnumField("开业时间")]
        OpenTime = 6,
        /// <summary>
        /// 项目类型
        /// </summary>
        [EnumField("项目类型")]
        ProjectType = 7,
        /// <summary>
        /// 商业体量
        /// </summary>
        [EnumField("商业体量")]
        CarrierSize = 8,
        /// <summary>
        /// 商业层数
        /// </summary>
        [EnumField("商业层数")]
        LayersNum = 9,
        /// <summary>
        /// 车位数量
        /// </summary>
        [EnumField("车位数量")]
        CarNum = 10,

        /// <summary>
        /// 业态规则
        /// </summary>
        [EnumField("业态规则")]
        CarrierPlan = 11,
        /// <summary>
        /// 招引目标
        /// </summary>
        [EnumField("招引目标")]
        CarrierTarget = 12,

        /// <summary>
        /// 总体定位
        /// </summary>
        [EnumField("总体定位")]
        Location = 13,
        /// <summary>
        /// 目标人群
        /// </summary>
        [EnumField("目标人群")]
        Crowd = 14,
        /// <summary>
        /// 地铁信息
        /// </summary>
        [EnumField("地铁信息")]
        CarrierMetro = 15,
    }

    /// <summary>
    /// 载体、楼宇下载项目
    /// </summary>
    public enum BuildCarrierExportEnum {

        /// <summary>
        /// 项目名称
        /// </summary>
        [EnumField("项目名称")]
        CarrierName = 1,

        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 2,

        /// <summary>
        /// 开发商
        /// </summary>
        [EnumField("开发商")]
        Developers = 3,

        /// <summary>
        /// 载体视频
        /// </summary>
        [EnumField("载体视频")]
        VideoUrl = 4,

        /// <summary>
        /// 项目地址
        /// </summary>
        [EnumField("项目地址")]
        Address = 5,

        /// <summary>
        /// 开业时间
        /// </summary>
        [EnumField("开业时间")]
        OpenTime = 6,

        /// <summary>
        /// 项目分类
        /// </summary>
        [EnumField("项目分类")]
        CategoryType = 7,


        /// <summary>
        /// 项目分类
        /// </summary>
        [EnumField("资产权属")]
        Ascription = 8,

        /// <summary>
        /// 项目面积
        /// </summary>
        [EnumField("项目面积")]
        CarrierSize = 9,

        /// <summary>
        /// 物业构成
        /// </summary>
        [EnumField("物业构成")]
        PropertyComposition = 10,

        /// <summary>
        /// 项目发展及定位
        /// </summary>
        [EnumField("项目发展及定位")]
        Location = 11,

        /// <summary>
        /// 项目发展及定位
        /// </summary>
        [EnumField("周边人群结构特征")]
        Crowd = 12,

        /// <summary>
        /// 人流量参数
        /// </summary>
        [EnumField("人流量参数")]
        VisitorsFlowrate = 13,

        /// <summary>
        /// 商业楼层
        /// </summary>
        [EnumField("商业楼层")]
        LayersNum = 14,

        /// <summary>
        /// 水电气及配套
        /// </summary>
        [EnumField("水电气及配套")]
        SupportingFacilities = 15,

        /// <summary>
        /// 管理公司及管理费
        /// </summary>
        [EnumField("管理公司及管理费")]
        ManagementCompany = 16,

        /// <summary>
        /// 目标招商业态及品牌需求
        /// </summary>
        [EnumField("目标招商业态及品牌需求")]
        BrandDemand = 17,

        /// <summary>
        /// 地铁信息
        /// </summary>
        [EnumField("地铁信息")]
        MetroInfo = 18,
    }
}
