﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.WeChatStatistics
{
    /// <summary>
    /// 微信小程序统计
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Wechat_Statistics
    {

        //新载体数量，新楼宇数，新品牌数量，新企业数，载体总数，楼宇总数，品牌总数，企业总数，留存用户、活跃留存、打开次数，访问次数、访问人数、人均停留时长、次均停留时长、平均访问深度、转发次数、转发人数、累计用户数，访问载体数，访问楼宇数，访问品牌数，访问企业数。
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        #region  系统统计信息

        /// <summary>
        /// 新载体数量
        /// </summary>
        public int CarrierNum { get; set; }

        /// <summary>
        /// 新楼宇数
        /// </summary>
        public int BuildingCarrierNum { get; set; }

        /// <summary>
        /// 新品牌数量
        /// </summary>
        public int BrandNum { get; set; }


        /// <summary>
        /// 新企业数
        /// </summary>
        public int EnterpriseNum { get; set; }

        /// <summary>
        /// 载体总数
        /// </summary>
        public int CarrierTotalNum { get; set; }

        /// <summary>
        /// 楼宇总数
        /// </summary>
        public int BuildingCarrierTotalNum { get; set; }

        /// <summary>
        /// 品牌总数
        /// </summary>
        public int BrandTotalNum { get; set; }


        /// <summary>
        /// 企业总数
        /// </summary>
        public int EnterpriseTotalNum { get; set; }


        /// <summary>
        /// 访问载体数
        /// </summary>
        public int CarrierVisitNum { get; set; }

        /// <summary>
        /// 访问楼宇数
        /// </summary>
        public int BuildingCarrierVisitNum { get; set; }

        /// <summary>
        /// 访问品牌数
        /// </summary>
        public int BrandVisitNum { get; set; }


        /// <summary>
        /// 访问企业数
        /// </summary>
        public int EnterpriseVisitNum { get; set; }

        #endregion


        /// <summary>
        /// 日期
        /// </summary>
        public DateTime CreateTime { get; set; }
        #region  用户访问小程序日留存
        /// <summary>
        /// 新增用户留存
        /// </summary>
        public int NewVisitUV { get; set; }

        /// <summary>
        /// 活跃用户留存
        /// </summary>
        public int VisitUV { get; set; }
        #endregion


        #region 用户访问小程序数据概况
        /// <summary>
        /// 累计用户数
        /// </summary>
        public int Visit_Total { get; set; }

        /// <summary>
        /// 转发次数
        /// </summary>
        public int Share_PV { get; set; }


        /// <summary>
        /// 转发人数
        /// </summary>
        public int Share_UV { get; set; }
        #endregion

        #region 用户访问小程序数据日趋势
        /// <summary>
        /// 打开次数
        /// </summary>
        public int Session_CNT { get; set; }
        /// <summary>
        /// 访问次数
        /// </summary>
        public int Visit_PV { get; set; }
        /// <summary>
        /// 访问人数
        /// </summary>
        public int Visit_UV { get; set; }
        /// <summary>
        /// 新用户数
        /// </summary>
        public int Visit_UV_New { get; set; }
        /// <summary>
        /// 人均停留时长 (浮点型，单位：秒)
        /// </summary>
        public decimal Stay_Time_UV { get; set; }
        /// <summary>
        /// 次均停留时长 (浮点型，单位：秒)
        /// </summary>
        public decimal Stay_Time_Session { get; set; }
        /// <summary>
        /// 平均访问深度 (浮点型)
        /// </summary>
        public decimal Visit_Depth { get; set; }
        #endregion
    }
}
