﻿using Mall.Model.Entity.WeChatStatistics;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 用户访问小程序日留存扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Wechat_Statistics_Extend : RB_Wechat_Statistics
    {
        /// <summary>
        /// 日期
        /// </summary>
        public string ref_date { get; set; }

        /// <summary>
        /// 结束日期
        /// </summary>
        public string endDate { get; set; }
        /// <summary>
        /// 新增用户留存
        /// </summary>
        public List<DailyRetainVisit> visit_uv_new { get; set; }

        /// <summary>
        /// 活跃用户留存
        /// </summary>
        public List<DailyRetainVisit> visit_uv { get; set; }
    }
    public class DailyRetainVisit
    {
        /// <summary>
        /// 标识，0开始，表示当天，1表示1天后。依此类推，key取值分别是：0,1,2,3,4,5,6,7,14,30
        /// </summary>
        public int key { get; set; }

        /// <summary>
        /// key对应日期的新增用户数/活跃用户数（key=0时）或留存用户数（k>0时）
        /// </summary>
        public int value { get; set; }
    }

    public class DailyVisitTrend
    {
        /// <summary>
        /// 数据列表
        /// </summary>
        public List<DailyVisitTrendItem> list { get; set; }
    }

    public class DailyVisitTrendItem
    {
        /// <summary>
        /// 日期，格式为 yyyymmdd
        /// </summary>
        public string ref_date { get; set; }

        #region 用户访问小程序数据日趋势
        /// <summary>
        /// 打开次数
        /// </summary>
        public int session_cnt { get; set; }
        /// <summary>
        /// 访问次数
        /// </summary>
        public int visit_pv { get; set; }
        /// <summary>
        /// 访问人数
        /// </summary>
        public int visit_uv { get; set; }
        /// <summary>
        /// 新用户数
        /// </summary>
        public int visit_uv_new { get; set; }
        /// <summary>
        /// 人均停留时长 (浮点型，单位：秒)
        /// </summary>
        public decimal stay_time_uv { get; set; }
        /// <summary>
        /// 次均停留时长 (浮点型，单位：秒)
        /// </summary>
        public decimal stay_time_session { get; set; }
        /// <summary>
        /// 平均访问深度 (浮点型)
        /// </summary>
        public decimal visit_depth { get; set; }
        #endregion


        #region  用户访问小程序数据概况
        /// <summary>
        /// 转发次数
        /// </summary>
        public int share_pv { get; set; }
        /// <summary>
        /// 转发人数
        /// </summary>
        public int share_uv { get; set; }
        /// <summary>
        /// 累计用户数
        /// </summary>
        public int visit_total { get; set; }
        #endregion
    }
}
