﻿using Mall.Model.Entity.TradePavilion;
using Mall.Model.Entity.WeChatStatistics;
using Mall.Model.Extend.Miai;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 微信小程序统计仓储类
    /// </summary>
    public class RB_Wechat_StatisticsRepository : BaseRepository<RB_Wechat_Statistics>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Wechat_Statistics_Extend> GetList(RB_Wechat_Statistics_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Wechat_Statistics_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Wechat_Statistics_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Wechat_Statistics_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ref_date))
            {
                where += $@" and  DATE_FORMAT({nameof(RB_Wechat_Statistics_Extend.CreateTime)},'%Y-%m-%d' ) >= DATE_FORMAT('{dmodel.ref_date}','%Y-%m-%d' ) ";
            }
            if (!string.IsNullOrEmpty(dmodel.endDate))
            {
                where += $@" and  DATE_FORMAT({nameof(RB_Wechat_Statistics_Extend.CreateTime)},'%Y-%m-%d' ) <= DATE_FORMAT('{dmodel.endDate}','%Y-%m-%d' ) ";
            }
            string sql = $@"select * from RB_Wechat_Statistics where {where}";
            return Get<RB_Wechat_Statistics_Extend>(sql).ToList();
        }
    }
}
