﻿
using System.Collections.Generic;

namespace Mall.ThirdCore.Adapay.Model
{
    /// <summary>
    /// 汇付天下 支付回调
    /// </summary>
    public class AdaPayResultModel 
    {
        /// <summary>
        /// 由 Adapay 生成的支付对象 id， 该 id 在 Adapay 系统内唯一
        /// </summary>
        public string id { get; set; }
        /// <summary>
        /// 支付创建时的 10 位时间戳
        /// </summary>
        public string created_time { get; set; }
        /// <summary>
        /// 请求订单号，只能为英文、数字或者下划线的一种或多种组合，保证在app_id下唯一
        /// </summary>
        public string order_no { get; set; }
        /// <summary>
        /// 是否 prod模式，true 是 prod模式，false 是 mock模式
        /// </summary>
        public string prod_mode { get; set; }
        /// <summary>
        /// 控制台 主页面应用的app_id
        /// </summary>
        public string app_id { get; set; }
        /// <summary>
        /// 支付渠道，参见 支付渠道 说明
        /// </summary>
        public string pay_channel { get; set; }
        /// <summary>
        /// 交易金额（必须大于 0），保留两位小数点，如0.10、100.05等
        /// </summary>
        public decimal pay_amt { get; set; }
        /// <summary>
        /// 详见 货币代码
        /// </summary>
        public string currency { get; set; }
        /// <summary>
        /// 可临时用来查询支付订单状态的链接，此链接的有效期只有30分钟
        /// </summary>
        public string query_url { get; set; }
        /// <summary>
        /// 订单附加说明
        /// </summary>
        public string description { get; set; }
        /// <summary>
        /// 支付渠道请求成功返回的额外参数。详见 支付渠道 expend参数 说明
        /// </summary>
        public object expend { get; set; }
        /// <summary>
        /// 用户账单上的商户订单号
        /// </summary>
        public string party_order_id { get; set; }
        /// <summary>
        /// 用户账单上的交易订单号
        /// </summary>
        public string out_trans_id { get; set; }
        /// <summary>
        /// 用户支付完成时间
        /// </summary>
        public string end_time { get; set; }
        /// <summary>
        /// 当前交易状态，参见 状态 说明
        /// </summary>
        public string status { get; set; }
        /// <summary>
        /// 错误码，详见 错误
        /// </summary>
        public string error_code { get; set; }
        /// <summary>
        /// 错误描述，详见 错误
        /// </summary>
        public string error_msg { get; set; }
        /// <summary>
        /// 错误类型，详见 错误
        /// </summary>
        public string error_type { get; set; }
        /// <summary>
        /// 当发生参数错误时返回具体的参数名，便于定位错误原因，详见 错误
        /// </summary>
        public string invalid_param { get; set; }



        //以下退款
        /// <summary>
        /// 退款单号
        /// </summary>
        public string refund_order_no { get; set; }

        /// <summary>
        /// 退费描述
        /// </summary>
        public string reason { get; set; }

        /// <summary>
        /// 退款目标  =>支付对象 id
        /// </summary>
        public string payment_id { get; set; }

        /// <summary>
        /// 退款目标  =>支付对象订单号
        /// </summary>
        public string payment_order_no { get; set; }

        /// <summary>
        /// 退款金额
        /// </summary>
        public decimal refund_amt { get; set; }

        /// <summary>
        /// 退款手续费
        /// </summary>
        public decimal fee_amt { get; set; }
    }

}
