﻿import md5 from 'js-md5'

export default {
    data: {
        loginUser: {},
        apiurl: ''
    },
    install(Vue, options) {
        Vue.prototype.isOnline = function () {
                return process.env.NODE_ENV !== 'development';
            },
            //域名管理对象
            Vue.prototype.domainManager = function () {
                //CRM API
                let domainUrl = "";
                domainUrl = "http://192.168.10.2:8098";
                //domainUrl = "http://localhost:5003";
                let locationName = window.location.hostname;
                //旅游ERPApi
                let domainPostUrl = "http://192.168.10.2:8083"
                if (this.isOnline()) {
                    if (window.location.host.indexOf('fcrmyx.oytour.com') != -1) {
                        domainUrl = "http://crm.oytour.com"
                        domainPostUrl = "http://reborn.oytour.com"
                    } else {
                        domainUrl = "http://testcrm.oytour.com"
                        domainPostUrl = "http://testapi.oytour.com"
                    }
                }
                var obj = {
                    //主地址
                    DomainUrl: domainUrl,
                    DownLoadContractUrl: domainPostUrl,
                    //阿里服务器地址
                    AliUrl: "https://reborndev.oss-cn-hangzhou.aliyuncs.com",
                    //本站文件流下载地址
                    LocalFileStreamDownLoadUrl: domainUrl + "/api/file/GetFileFromWebApi",
                    //PDF文件预览地址
                    PDFViewUrl: domainUrl + "/plug/pdf/web/viewer.html?file=",
                    //SocketUrl
                    WebSocketUrl: "ws://192.168.1.110:8080?account=",
                    //google地图图片地址
                    GoogleMapImageUrl: "http://imgfile.oytour.com",
                    //常用提交数据URL 
                    PostUrl: domainUrl,
                    PostUrl2: domainPostUrl + "/api/common/post",
                    javaUrl: locationName.indexOf('testb2b') == -1 ? "http://efficient.oytour.com" : locationName.indexOf('testb2b.oytour.com') !== -1 ? "http://47.96.12.235:9001" : "http://192.168.10.215:9000",
                    ViittoFileUrl: locationName.indexOf('oytour') !== -1 || locationName.indexOf('testb2b.oytour.com') !== -1 ? "http://staticfile.oytour.com" : 'http://192.168.10.214:8130',
                    UploadUrl: locationName.indexOf('oytour') !== -1 || locationName.indexOf('testb2b.oytour.com') !== -1 ? "http://uploadfile.oytour.com" : "http://192.168.10.214:8120",
                    LocalFileStreamDownLoadUrl: domainUrl + "/api/file/GetFileFromWebApi",
                };
                return obj;
            },
            Vue.prototype.GetLocalFile = function (cmd, msg, fileName, successCall) {
                var apiurl = this.domainManager().LocalFileStreamDownLoadUrl;
                var timestamp = (new Date()).valueOf();
                if (!localStorage.userInfo && localStorage.userInfo != "" && this.$route.path.toLowerCase() != "/login") {
                    this.$router.push({
                        path: '/login'
                    })
                }
                var token = "";
                var key = "";
                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().secretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "msg": msg,
                    "cmd": cmd,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                this.$http.post(apiurl, postData, {
                    responseType: 'arraybuffer'
                }).then((res) => {
                    let blob = new Blob([res.data], {
                        type: "application/vnd.ms-excel"
                    })
                    let url = URL.createObjectURL(blob);
                    let link = document.createElement('a');
                    link.href = url;
                    link.setAttribute("download", fileName);
                    document.body.appendChild(link);
                    link.click();
                    successCall(res);
                }).catch(function (res) {});
            },
            //价钱格式化，三位数逗号分隔，保留两位小数   duanjun
            Vue.prototype.moneyFormat = function (value) {
                let nStr = Number(value).toFixed(2)
                nStr += '';
                let x = nStr.split('.');
                let x1 = x[0];
                let x2 = x.length > 1 ? '.' + x[1] : '';
                var rgx = /(\d+)(\d{3})/;
                while (rgx.test(x1)) {
                    x1 = x1.replace(rgx, '$1' + ',' + '$2');
                }
                return x1 + x2;
            },
            //消息成功提示
            Vue.prototype.Success = function (msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "success"
                });
            },
            //错误提示
            Vue.prototype.Error = function (msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "error"
                });
            },

            //一般提示
            Vue.prototype.Info = function (msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "info"
                });
            },
            //警告提示
            Vue.prototype.Warning = function (msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "warning"
                });
            },
            //Confirm
            Vue.prototype.Confirm = function (msg, callback) {
                this.$confirm(msg, "提示", {
                        confirmButtonText: "确定",
                        cancelButtonText: "取消",
                        type: "warning"
                    })
                    .then(() => {
                        if (typeof callback === 'function') {
                            callback();
                        }
                    })
                    .catch(() => {
                        this.Info("已取消操作");
                    });
            },
            //压缩图片
            //path : 图片路径
            //type : m_filt  填充  m_w  宽度固定 高度不固定  m_h 高度固定 宽度不固定
            //   w : 宽
            //   h : 高
            Vue.prototype.compressImg = function (path, type, w, h) {
                let url = this.domainManager().UploadUrl;
                let poise = 'width=';
                w = w ? w : ''
                h = h ? h : ''
                if (type === 'w') {
                    poise = 'width'
                } else if (type === 'h') {
                    poise = 'height'
                }
                return path.split('?')[0] + '?width=' + w;
            }
        //打开新窗口连接
        Vue.prototype.OpenNewUrl = function (URL) {
            if (URL != '') {
                window.open('http://' + URL, '_blank');
            }
        }
        //旅游ERP接口
        Vue.prototype.apipost2 = function (cmd, msg, successCall, faildCall, isOnline) {
            if (msg == null || msg == "") {
                msg = {}
            }
            var apiurl = this.domainManager().PostUrl2;
            var timestamp = (new Date()).valueOf();
            this.apiurl = apiurl;
            if (!localStorage.userInfo && localStorage.userInfo != "" && this.$route.path.toLowerCase() != "/login") {
                this.$router.push({
                    path: '/login'
                })
            }
            var token = "";
            var key = "";
            if (this.getLocalStorage() != null) {
                token = this.getLocalStorage().token;
                key = this.getLocalStorage().SecretKey;
            }
            var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
            var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
            let tempLanguage = 0;
            var postData = {
                "msg": msg,
                "cmd": cmd,
                "timestamp": timestamp,
                "token": token,
                "sign": md5Str,
                "languageId": tempLanguage
            }
            this.$http.post(apiurl, postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Referer-Viitto': this.$route.path
                    }
                })
                .then(res => {
                    if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                        this.$router.push({
                            path: '/login'
                        });
                    } else if (res.resultCode == 10005) {
                        this.$router.go(-1);
                    } else {
                        successCall(res);
                    }
                }, faildCall)
        }
        Vue.prototype.apipost = function (cmd, msg, successCall, faildCall) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().PostUrl + cmd;
                var timestamp = (new Date()).valueOf();
                var token = "";
                var key = "";
                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().secretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                if (localStorage.g && localStorage.g != 'undefined') {
                    postData.groupId = 2;
                }
                this.$http.post(apiurl, postData, {
                        headers: {
                            'Content-Type': 'application/json',
                            'Referer-Viitto': this.$route.path
                        }
                    })
                    .then(res => {
                        if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                            this.$router.push({
                                path: '/login'
                            })
                        } else if (res.data.resultCode == 10005) {
                            this.$router.go(-1)
                        } else {
                            successCall(res)
                        }
                    }, faildCall)
            },
            Vue.prototype.apiJavaPost = function (cmd, msg, successCall, faildCall) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().javaUrl + cmd;
                var timestamp = (new Date()).valueOf();
                this.apiurl = apiurl;
                var token = "";
                var key = "";

                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().secretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);

                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                if (localStorage.g && localStorage.g != 'undefined') {

                    postData.groupId = 2;
                }
                this.$http.post(apiurl, postData, {
                        headers: {
                            'Content-Type': 'application/json',
                            'Referer-Viitto': this.$route.path
                        }
                    })
                    .then(res => {
                        if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {

                            this.$router.push({
                                path: '/login'
                            })

                        } else if (res.data.resultCode == 10005) {
                            this.$router.go(-1)
                        } else {
                            if (res.data.award && res.data.award.mName !== null) {
                                this.MsgBus.$emit('openRaffleTickets', res.data.award)
                            }
                            successCall(res)
                        }
                    }, faildCall)
            },
            Vue.prototype.getAction = function (actionId, lineId) {

                let msg = {};
                msg.actionId = actionId;
                if (lineId) {
                    msg.lineId = lineId;
                }
                this.apiJavaPost('/api/b2b/home/getSpecialAction', msg, res => {
                    this.Travelload = false;
                    if (res.data.resultCode == 1) {

                    } else {
                        this.Error(res.data.message);
                    }
                }, null)
            }

        //验证只能输入2位小数
        Vue.prototype.checkPrice = function (item, filed) {
            var value = "";
            if (typeof item[filed] == "string") {
                value = item[filed];
            } else {
                value = item[filed].toString();
            }
            value = value.replace(/[^\d.]/g, ""); //清除“数字”和“.”以外的字符
            value = value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的
            value = value
                .replace(".", "$#$")
                .replace(/\./g, "")
                .replace("$#$", ".");
            value = value.replace(/^(\-)*(\d+)\.(\d\d).*$/, "$1$2.$3"); //只能输入两个小数
            if (value.indexOf(".") < 0 && value != "") {
                //以上已经过滤，此处控制的是如果没有小数点，首位不能为类似于 01、02的金额
                value = parseFloat(value);
            }
            item[filed] = value;
        }
        //验证只能输入整数
        Vue.prototype.checkInteger = function (item, filed) {
            var value = "";
            if (typeof item[filed] == "string") {
                value = item[filed];
            } else {
                value = item[filed].toString();
            }
            value = value.replace(this.$commonUtils.Regex.isInteger, "");
            item[filed] = value;
        }
    }
}