import axios from 'axios'
import domainManager from './domainManager'
const getLocalStorage = function () {
    var localStorageData = window.localStorage["userInfo"];
    if (localStorageData != undefined) {
        return JSON.parse(localStorageData);
    } else {
        return null;
    }
}
//CRM接口
export default function (cmd, content, msg, successCall, faildCall) {
    if (msg == null || msg == "") {
        msg = {}
    }
    var apiurl = domainManager().PostUrl + cmd;
    var timestamp = (new Date()).valueOf();
    var token = "";
    var key = "";
    if (getLocalStorage() != null) {
        token = getLocalStorage().token;
        key = getLocalStorage().secretKey;
    }
    var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
    var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
    var postData = {
        "msg": msg,
        "timestamp": timestamp,
        "token": token,
        "sign": md5Str
    }
    if (localStorage.g && localStorage.g != 'undefined') {
        postData.groupId = 2;
    }
    axios.post(apiurl, postData, {
            headers: {
                'Content-Type': 'application/json',
                'Referer-Viitto': content.$route.path
            }
        })
        .then(res => {
            if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                content.$router.push({
                    path: '/login'
                })
            } else if (res.data.resultCode == 10005) {
                content.$router.go(-1)
            } else {
                successCall(res)
            }
        }, faildCall)
}