import md5 from 'js-md5'
import domainManager from './domainManager'
export default {
    data: {
        loginUser: {},
        apiurl: ''
    },
    domainManager,
    install(Vue, options) {
        Vue.prototype.isOnline = function() {
                return process.env.NODE_ENV !== 'development';
            },
            //域名管理对象
            Vue.prototype.domainManager = domainManager,

            //消息成功提示
            Vue.prototype.Success = function(msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "success"
                });
            },
            //错误提示
            Vue.prototype.Error = function(msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "error"
                });
            },

            //一般提示
            Vue.prototype.Info = function(msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "info"
                });
            },
            //警告提示
            Vue.prototype.Warning = function(msg) {
                this.$message({
                    message: msg,
                    duration: 2000,
                    type: "warning"
                });
            },
            //Confirm
            Vue.prototype.Confirm = function(msg, callback) {
                this.$confirm(msg, "提示", {
                        confirmButtonText: "确定",
                        cancelButtonText: "取消",
                        type: "warning"
                    })
                    .then(() => {
                        if (typeof callback === 'function') {
                            callback();
                        }
                    })
                    .catch(() => {
                        this.Info("已取消操作");
                    });
            },
            //压缩图片
            //path : 图片路径
            //type : m_filt  填充  m_w  宽度固定 高度不固定  m_h 高度固定 宽度不固定
            //   w : 宽
            //   h : 高
            Vue.prototype.compressImg = function(path, type, w, h) {
                let url = this.domainManager().UploadUrl;
                let poise = 'width=';
                w = w ? w : ''
                h = h ? h : ''
                if (type === 'w') {
                    poise = 'width'
                } else if (type === 'h') {
                    poise = 'height'
                }
                return path.split('?')[0] + '?width=' + w;
            }


        //旅游ERP接口
        Vue.prototype.apipost2 = function(cmd, msg, successCall, faildCall, isOnline) {
            if (msg == null || msg == "") {
                msg = {}
            }
            var apiurl = this.domainManager().ERPApiUrl;
            var timestamp = (new Date()).valueOf();
            this.apiurl = apiurl;
            if (!localStorage.userInfo && localStorage.userInfo != "" && this.$route.path.toLowerCase() != "/login") {
                this.$router.push({
                    path: '/login'
                })
            }
            var token = "";
            var key = "";
            if (this.getLocalStorage() != null) {
                token = this.getLocalStorage().token;
                key = this.getLocalStorage().SecretKey;
            }
            var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
            var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
            let tempLanguage = 0;
            var postData = {
                "msg": msg,
                "cmd": cmd,
                "timestamp": timestamp,
                "token": token,
                "sign": md5Str,
                "languageId": tempLanguage
            }
            this.$http.post(apiurl, postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Referer-Viitto': this.$route.path
                    }
                })
                .then(res => {
                    if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                        this.$router.push({
                            path: '/login'
                        });
                    } else if (res.resultCode == 10005) {
                        this.$router.go(-1);
                    } else {
                        successCall(res);
                    }
                }, faildCall)
        }

        //CRM接口
        Vue.prototype.apipost = function(cmd, msg, successCall, faildCall) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().PostUrl + cmd;
                var timestamp = (new Date()).valueOf();
                var token = "";
                var key = "";
                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().secretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                if (localStorage.g && localStorage.g != 'undefined') {
                    postData.groupId = 2;
                }
                this.$http.post(apiurl, postData, {
                        headers: {
                            'Content-Type': 'application/json',
                            'Referer-Viitto': this.$route.path
                        }
                    })
                    .then(res => {
                        if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                            this.$router.push({
                                path: '/login'
                            })
                        } else if (res.data.resultCode == 10005) {
                            this.$router.go(-1)
                        } else {
                            successCall(res)
                        }
                    }, faildCall)
            },

            // 自动登录HTTP提交数据
            Vue.prototype.apipostLogin = function(cmd, msg, successCall, faildCall) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().PostUrl + cmd;
                var timestamp = (new Date()).valueOf();
                var token = "";
                var key = "";
                var data = JSON.parse(localStorage.erpuserInfo)
                if (localStorage.erpuserInfo != null) {
                    token = data.token;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                if (localStorage.g && localStorage.g != 'undefined') {
                    postData.groupId = 2;
                }
                this.$http.post(apiurl, postData, {
                        headers: {
                            'Content-Type': 'application/json',
                            'Referer-Viitto': this.$route.path
                        }
                    })
                    .then(res => {
                        if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
                            this.$router.push({
                                path: `/automaticLogin?token=${data.token}&data=${JSON.stringify(data.parameter)}`
                            })
                        } else if (res.data.resultCode == 10005) {
                            this.$router.go(-1)
                        } else {
                            successCall(res)
                        }
                    }, faildCall)
            },

            //Java接口
            Vue.prototype.apiJavaPost = function(cmd, msg, successCall, faildCall) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().javaUrl + cmd;
                var timestamp = (new Date()).valueOf();
                this.apiurl = apiurl;
                var token = "";
                var key = "";

                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().secretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);

                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                if (localStorage.g && localStorage.g != 'undefined') {

                    postData.groupId = 2;
                }
                this.$http.post(apiurl, postData, {
                        headers: {
                            'Content-Type': 'application/json',
                            'Referer-Viitto': this.$route.path
                        }
                    })
                    .then(res => {
                        if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {

                            this.$router.push({
                                path: '/login'
                            })

                        } else if (res.data.resultCode == 10005) {
                            this.$router.go(-1)
                        } else {
                            if (res.data.award && res.data.award.mName !== null) {
                                this.MsgBus.$emit('openRaffleTickets', res.data.award)
                            }
                            successCall(res)
                        }
                    }, faildCall)
            },

            //下载文件
            Vue.prototype.GetLocalFile = function(cmd, msg, fileName, callBack) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().PostUrl + cmd;
                var timestamp = (new Date()).valueOf();
                var token = "";
                var key = "";
                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().SecretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                this.$http.post(apiurl, postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Referer-Viitto': this.$route.path,
                    },
                    responseType: 'blob'
                }).then((res) => {
                    let blob = new Blob([res.data], {
                        type: "application/vnd.ms-excel"
                    })
                    let url = URL.createObjectURL(blob);
                    let link = document.createElement('a');
                    link.href = url;
                    link.setAttribute("download", fileName);
                    document.body.appendChild(link);
                    link.click();
                    if (callBack) {
                        var result = {
                            Code: 1
                        };
                        callBack(result);
                    }
                }).catch(function(res) {
                    console.log("GetLocalFile", res);
                });
            }
            //erp下载文件
            Vue.prototype.GetLocalFile2 = function(cmd, msg, fileName, callBack) {
                if (msg == null || msg == "") {
                    msg = {}
                }
                var apiurl = this.domainManager().ERPApiUrlFile; 
                var timestamp = (new Date()).valueOf();
                var token = "";
                var key = "";
                if (this.getLocalStorage() != null) {
                    token = this.getLocalStorage().token;
                    key = this.getLocalStorage().SecretKey;
                }
                var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
                var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
                var postData = {
                    "cmd": cmd,
                    "msg": msg,
                    "timestamp": timestamp,
                    "token": token,
                    "sign": md5Str
                }
                this.$http.post(apiurl, postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Referer-Viitto': this.$route.path,
                    },
                    responseType: 'blob'
                }).then((res) => {
                    let blob = new Blob([res.data], {
                        type: "application/vnd.ms-excel"
                    })
                    let url = URL.createObjectURL(blob);
                    let link = document.createElement('a');
                    link.href = url;
                    link.setAttribute("download", fileName);
                    document.body.appendChild(link);
                    link.click();
                    if (callBack) {
                        var result = {
                            Code: 1
                        };
                        callBack(result);
                    }
                }).catch(function(res) {
                    console.log("GetLocalFile", res);
                });
            }
    }
}