import Vue from "vue";
import Router from "vue-router";
import index from "./views/index";
import login from "./views/login";
import Home from "./components/Home"
import customerManage from "./components/customerManage/customerManage"
import customerManageDemo from "./components/customerManage/customerManageDemo"
import businessManagement from "./components/businessManagement/businessManagement"
import clueManagement from "./components/clueManagement/clueManagement"
import contactsManagement from "./components/contactsManagement/contactsManagement"
import watersManagement from "./components/watersManagement/watersManagement"
import waitMatter from "./components/waitMatter/waitMatter"
import datasheet from './components/datasheet/index'
import contractManagement from "./components/contractManagement/contractManagement"
import guestManagement from "./components/guestManagement/guestManagement"
import customerApr from "./components/approval/customerApr"
import customerMap from "./components/customerManage/customerMap"
import customerConfiguration from "./components/customerManage/customerConfiguration"
Vue.use(Router);

export default new Router({
    mode: "hash",
    base: process.env.BASE_URL,
    routes: [{
            path: "/login",
            name: "login",
            component: login,
            meta: {
                title: "欢迎使用CRM系统-请登录使用",
                "http-equiv": "X-UA-Compatible",
                content: "IE=Edge,chrome=1"
            }
        },
        {
            path: "/",
            name: "login",
            component: login,
            meta: {
                title: "欢迎使用CRM系统-请登录使用",
                "http-equiv": "X-UA-Compatible",
                content: "IE=Edge,chrome=1"
            }
        },
        {
            path: "/index",
            name: "index",
            component: index,
            meta: {
                title: "大象CRM",
                "http-equiv": "X-UA-Compatible",
                content: "IE=Edge,chrome=1"
            },
            children: [{
                    path: "/Home",
                    name: "Home",
                    component: Home,
                    meta: {
                        title: "CRM-仪表盘",
                    },
                },
                {
                    path: "/customerManage",
                    name: "customerManage",
                    component: customerManage,
                    meta: {
                        title: "客户管理"
                    }
                },
                {
                    path: "/customerManageDemo",
                    name: "customerManageDemo",
                    component: customerManageDemo,
                    meta: {
                        title: "客户管理"
                    }
                },
                {
                    path: "/businessManagement",
                    name: "businessManagement",
                    component: businessManagement,
                    meta: {
                        title: "商机管理"
                    }
                },
                {
                    path: "/clueManagement",
                    name: "clueManagement",
                    component: clueManagement,
                    meta: {
                        title: "线索管理"
                    }
                },
                {
                    path: "/contactsManagement",
                    name: "contactsManagement",
                    component: contactsManagement,
                    meta: {
                        title: "联系人管理"
                    }
                },
                {
                    path: "/watersManagement",
                    name: "watersManagement",
                    component: watersManagement,
                    meta: {
                        title: "公海管理"
                    }
                },
                {
                    path: "/waitMatter",
                    name: "waitMatter",
                    component: waitMatter,
                    meta: {
                        title: "待办事项"
                    }
                },
                {
                    path: "/datasheet",
                    name: "datasheet",
                    component: datasheet,
                    meta: {
                        title: "数据明细"
                    }
                },
                {
                    path: "/old",
                    name: "old",
                    component: () =>
                        import ('./components/statistics/old.vue'),
                    meta: {
                        title: "客户年龄分布统计"
                    }
                },
                {
                    path: "/marital",
                    name: "marital",
                    component: () =>
                        import ('./components/statistics/marital.vue'),
                    meta: {
                        title: "客户婚姻状态统计"
                    }
                },
                {
                    path: "/sex",
                    name: "sex",
                    component: () =>
                        import ('./components/statistics/sex.vue'),
                    meta: {
                        title: "客户性别统计"
                    }
                },
                {
                    path: "/tourType",
                    name: "tourType",
                    component: () =>
                        import ('./components/statistics/tourType.vue'),
                    meta: {
                        title: "出游类型统计"
                    }
                },
                {
                    path: "/festivalOrderList",
                    name: "festivalOrderList",
                    component: () =>
                        import ('./components/statistics/festivalOrderList.vue'),
                    meta: {
                        title: "特殊节假日统计"
                    }
                },
                {
                    path: "/marriage",
                    name: "marriage",
                    component: () =>
                        import ('./components/statistics/marriage.vue'),
                    meta: {
                        title: "婚姻统计"
                    }
                },
                {
                    path: "/sellevent",
                    name: "sellevent",
                    component: () =>
                        import ('./components/sellevent/index.vue'),
                    meta: {
                        title: "营销事件"
                    }
                },
                {
                    path: "/birthdayEvent",
                    name: "birthdayEvent",
                    component: () =>
                        import ('./components/sellevent/brithday.vue'),
                    meta: {
                        title: "生日事件"
                    }
                },
                {
                    path: "/graduationEvent",
                    name: "graduationEvent",
                    component: () =>
                        import ('./components/sellevent/graduation.vue'),
                    meta: {
                        title: "毕业季事件"
                    }
                },
                {
                  path: "/festivalEvent",
                  name: "festivalEvent",
                  component: ()=>import('./components/sellevent/festival.vue'),
                  meta: {
                  title: "节日事件"
                  }
                },
                {
                  path: "/emergencyEvent",
                  name: "emergencyEvent",
                  component: ()=>import('./components/sellevent/emergency.vue'),
                  meta: {
                  title: "突发事件"
                  }
                },
                {
                    path: "/feedbackEvent",
                    name: "feedbackEvent",
                    component: ()=>import('./components/sellevent/feedback.vue'),
                    meta: {
                    title: "意见反馈事件"
                    }
                },
                {
                    path: "/nexttimeEvent",
                    name: "nexttimeEvent",
                    component: ()=>import('./components/sellevent/nexttime.vue'),
                    meta: {
                    title: "下次出行事件"
                    }
                },
                {
                    path: "/newlineEvent",
                    name: "newlineEvent",
                    component: ()=>import('./components/sellevent/newline.vue'),
                    meta: {
                    title: "新线路推广事件"
                    }
                },
                {
                    path: "/newseriesEvent",
                    name: "newseriesEvent",
                    component: ()=>import('./components/sellevent/newseries.vue'),
                    meta: {
                    title: "新系列推广事件"
                    }
                },
                {
                    path: "/happyPassbook",
                    name: "happyPassbook",
                    component: ()=>import('./components/sellevent/happyPassbook.vue'),
                    meta: {
                    title: "返佣、幸福存折通知事件"
                    }
                },
                {
                    path: "/newfestivalEvent",
                    name: "newfestivalEvent",
                    component: ()=>import('./components/sellevent/newfestival.vue'),
                    meta: {
                    title: "节日事件"
                    }
                },
                
                
                {
                    path: "/gaoxiao",
                    name: "gaoxiao",
                    component: () =>
                        import ('./components/statistics/gaoxiao.vue'),
                    meta: {
                        title: "高校在读/毕业统计"
                    }
                },
                {
                    path: "/job",
                    name: "job",
                    component: () =>
                        import ('./components/statistics/job.vue'),
                    meta: {
                        title: "职业类型统计"
                    }
                },
                {
                    path: "/assets",
                    name: "assets",
                    component: () =>
                        import ('./components/statistics/assets.vue'),
                    meta: {
                        title: "资产"
                    }
                },
                {
                    path: "/deving",
                    name: "deving",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/deving1",
                    name: "deving1",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/deving2",
                    name: "deving2",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/deving3",
                    name: "deving3",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/deving4",
                    name: "deving4",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/deving5",
                    name: "deving5",
                    component: () =>
                        import ('./components/dev/index.vue'),
                    meta: {
                        title: "开发中..."
                    }
                },
                {
                    path: "/roomStatistical",
                    name: "roomStatistical",
                    component: () =>
                        import ('./components/statistics/roomStatistical.vue'),
                    meta: {
                        title: "住房统计"
                    }
                },
                {
                    path: "/season",
                    name: "season",
                    component: () =>
                        import ('./components/statistics/season.vue'),
                    meta: {
                        title: "季节"
                    }
                },
                {
                    path: "/Opinionpolls",
                    name: "Opinionpolls",
                    component: () =>
                        import ('./components/statistics/Opinionpolls.vue'),
                    meta: {
                        title: "意见调查"
                    }
                },

                {
                    path: "/unit",
                    name: "unit",
                    component: () =>
                        import ('./components/statistics/unit.vue'),
                    meta: {
                        title: "单位"
                    }
                },
                {
                    path: "/contractManagement",
                    name: "contractManagement",
                    component: contractManagement,
                    meta: {
                        title: "合同管理"
                    }
                },
                {
                    path: "/guestManagement",
                    name: "guestManagement",
                    component: guestManagement,
                    meta: {
                        title: "直客管理"
                    }
                },
                {
                    path: "/customerApr",
                    name: "customerApr",
                    component: customerApr,
                    meta: {
                        title: "客户审批"
                    }
                },
                {
                    path: "/customerMap",
                    name: "customerMap",
                    component: customerMap,
                    meta: {
                        title: "客户地图"
                    }
                },
                {
                    path: "/customerConfiguration",
                    name: "customerConfiguration",
                    component: customerConfiguration,
                    meta: {
                        title: "客户配置"
                    }
                }
            ]
        },
        {
            path: '/table',
            name: 'table',
            component: resolve => require(['@/views/table.vue'], resolve),
            meta: {
                title: '表格测试'
            }
        }
    ]
});