// component/Search/search.js
let app = getApp();
Component({
  /**
   * 组件的属性列表
   */
  properties: {

  },

  /**
   * 组件的初始数据
   */
  data: {
    array: ['美国', '中国', '巴西', '日本'],
    InputFous: false,
    CitySite: false,
    cityList: [],
    site:{
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    

  },

  /**
   * 组件的方法列表
   */
  methods: {
    InputFous(){
      wx.navigateTo({
        url: '/pages/SearchPage/SearchPage',
      })
    },
    getCityList() {
      app.$api('b2b_get_site', {}).then(res => {
        this.setData({
          cityList: res
        })
        console.log(this.data.cityList)
      }).catch(err => {})
    },
    SetCity(e) {
      let that=this;
      let site = {
        cityId: e.target.dataset.msg.cityId,
        companyId: e.target.dataset.msg.companyId,
        siteName: e.target.dataset.msg.siteName,
      }
      that.setData({
        site: site,
        CitySite:false,
      })
      this.triggerEvent('ChangeSite', that.data.site)
      wx.setStorage({
        key: "site",
        data: site,
        success: function() {
          
        },
        fail: function() {
          
        }
      })
    },
    CloseCity(e) {
      if (e.target.dataset.target == "self") {
        this.setData({
          CitySite: false,
        })
      }
    },
    ChangeSite() {
      this.setData({
        CitySite: true,
      })
    },
    bindPickerChange: function(e) {
      this.setData({
        index: e.detail.value
      })
    },
    ListenInput() {
      this.setData({
        InputFous: true,
      })
    },
  }
})