// components/amount/index.js
Component({
  options: {
    addGlobalClass: true,
  },
  /**
   * 组件的属性列表
   */
  properties: {
    count: { // 商品数量
      type: Number,
      value: 1
    },
    type:{ // 商品数量
      type: String,
    },
    chosenObj:{
      type: Object,
    },
  },

  /**
   * 组件的初始数据
   */
  data: {

  },

  /**
   * 组件的方法列表
   */
  methods: {
    inputChangeHandle: function (event) {
      let that = this;
      let type = that.data.type;
      var val = event.detail.value; //通过这个传递数据
      var myEventDetail = {
        val: val
      } 
      // 数据改变时 向父组件传递新数据
      this.triggerEvent('myevent', myEventDetail)
    },
    subtract: function () {
      let that=this;
      let type = that.data.type;
      if (this.data.chosenObj.startDate == "") {
        wx.showToast({
          title: "请先选择日期",
          icon: 'none',
          duration: 1000
        })
        return;
      }
      var count = this.data.count;
      count > 0 ? count-- : 0
      this.setData({
        count: count
      })
      var myEventDetail = {
        val: count
      }
      if (type == "cr") {
        this.triggerEvent('cRsubevent', myEventDetail)
      }
      if (type == "etz") {
        this.triggerEvent('etZsubevent', myEventDetail)
      }
      // 不占床
      if (type == "etbz") {
        this.triggerEvent('etbZsubevent', myEventDetail)
      }
      if (type == "ye") {
        this.triggerEvent('yEsubevent', myEventDetail)
      }
      
    },
    add: function () {
      let that=this;
      if (this.data.chosenObj.startDate==""){
        wx.showToast({
          title:"请先选择日期",
          icon: 'none',
          duration: 1000
        })
        return;
      }

      let type = that.data.type;
      var count = this.data.count;
      this.setData({
        count: ++count
      })
      var myEventDetail = {
        val: count
      }
      if (type=="cr"){
        this.triggerEvent('cRaddCount', myEventDetail)
      }
      if (type == "etz") {
        this.triggerEvent('etZaddCount', myEventDetail)
      }
      // 不占床
      if (type == "etbz") {
        this.triggerEvent('etbZaddCount', myEventDetail)
      }
      if (type == "ye") {
        this.triggerEvent('yEaddCount', myEventDetail)
      }
      
      
    }
  }
})
