// component/calendar/calendar.js
var util = require('../../utils/util.js')
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    currentDay: {
      type: String
    },
    priceData: {
      type: Array
    },
    isLogin: {
      type: Number
    },
    selectIndex: {
      type: Number
    },
    isVisa: {
      type: Number
    },
    visaB2CPrice: {
      type: String
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    week: ['日', '一', '二', '三', '四', '五', '六'],
    DaysInMonth: [],
    daysData: [],
  },

  /**
   * 组件的方法列表
   */
  methods: {
    selectDate(e){
      let item = e.currentTarget.dataset.item;
      let index = e.currentTarget.dataset.index;
      // console.log(item);
      if (item.price == 0 || item.price == "" || !item.color){
        return;
      }
      let msg={
        configId: item.configId,
        tcid: item.tcid,
        selectIndex:index,
        ymd: `${item.ym}-${item.day}`,

      };
      if (item.couponsId){
        msg.couponsId = item.couponsId;
        msg.priceId = item.priceId;
        msg.ticketId = item.ticketId;
        msg.price = item.price;
      }
      if(item.priceId){
        msg.priceId=item.priceId;
        msg.price = item.price;
      }
      this.triggerEvent('childrenEvent', msg);
    },
    getYearMonthDay() {
      let that = this;
      // console.log("currentDay", this.data.currentDay)
      // console.log("priceData", this.data.priceData)
      let currentYear = that.data.currentDay.substring(0, 4); //当前年份
      let currentMonth = that.data.currentDay.substring(5, 7); //当前月份	
      that.setData({
        daysData: that.data.priceData
      })

      let date = new Date();
      let strDate = date.getDate();
      let strMonth = (date.getMonth() + 1).toString();
      // alert(typeof strMonth)
      //判断是否是闰年
      if (that.isleapYears(currentYear)) {
        that.data.DaysInMonth = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
      } else {
        that.data.DaysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
      }
      let monthDay = that.data.DaysInMonth[Number(currentMonth) - 1]; //当前月的天数			
      let daysData = [];
      //给数据源赋值
      for (var i = 0; i < Number(monthDay); i++) {
        var priceDict = {
          "ymd": `${currentYear}-${currentMonth}-${i+1}`,
          "ym": `${currentYear}-${currentMonth}`,
          'day': String(i + 1),
          'price': 0,
          'dis': false
        };
        daysData.push(priceDict);
      }
      that.setData({
        daysData: daysData
      })
      // that.data.daysData = daysData;
      var currentDay = `${currentYear}-${currentMonth}-01`;
      var dateObject = new Date(currentDay);
      var firstDay = dateObject.getDay(); //得到每个月1号是周几
      
      for (var i in that.data.priceData) {
        var price = that.data.priceData[i];
        var dayIndex = price.startDate.substring(price.startDate.length - 2, price.startDate.length);
        var dayDict = daysData[Number(dayIndex) - 1];
        dayDict.price = that.isLogin !== 1 ? price.b2CPrice : price.b2BPrice;
        if (price.configIDDes){
          dayDict.configId = price.configIDDes;
          dayDict.tcid = price.tcid;
        }
        if (price.couponsId){
          dayDict.couponsId = price.couponsId;
          dayDict.priceId = price.priceId;
          dayDict.ticketId = price.ticketId;
        }
        if (price.priceId){
          dayDict.priceId=price.priceId;
        }
        if (dayIndex < strDate && strMonth == currentMonth) {
          dayDict.price = '';
        }
      }
      if (firstDay > 0) {
        var firstDayData = [];
        for (var i = 0; i < firstDay; i++) {
          var dict = {
            "ymd": `${currentYear}-${currentMonth}-${i + 1}`,
            "ym": `${currentYear}-${currentMonth}`,
            'day': ' ',
            price: '',
            'dis': true
          };
          firstDayData.push(dict);
        }
        // that.data.daysData = firstDayData.concat(daysData);
        let newData = firstDayData.concat(daysData);
        that.setData({
          daysData: newData
        })

      } else {
        // that.data.daysData = daysData;
        that.setData({
          daysData: daysData
        })
      }
      
      let Arr = that.data.daysData;
      let today = new Date().toLocaleDateString().split('/').join('-');
      Arr.forEach(item=>{
        if(Number(item.day<10)){
          item.day="0"+item.day;
        }
        item.color =false;
        if (!util.CompareDate(today, item.ymd)){
            item.color=true;
        }
      })
      // 签证价格日历
      if (that.data.isVisa) {
        let _this = this
        Arr.forEach(item=>{
          if (item.day!='0 ') {
            item.price = _this.data.visaB2CPrice
          }
        })
      }
      wx.hideLoading()
      that.setData({
        daysData: Arr
      })
      // console.log("daysData",that.data.daysData)
    },
    isleapYears(year) {
      if (((year % 4) == 0) && ((year % 100) != 0) || ((year % 400) == 0)) {
        return true;
      } else {
        return false;
      }
    },
  }
})