// component/chooseCity/chooseCity.js
let app = getApp();
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    type: {
      type: String
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    countryList: [],
    provinceList: [],
    cityList: [],
    countryID: "",
    provinceID: "",
    cityID: "",
    selectInfo: {
      name:"",
      id:"",
    },
    index:[0,0,0],
  },

  /**
   * 组件的方法列表
   */
  methods: {
    getCountry() {
      let that = this;
      app.$api('dict_post_Destination_GetCountry', {}).then(res => {
        this.setData({
          countryList: res
        })
        if (res.length > 0) {
          let countryInfo = that.data.countryList[0];
          that.getProvince(countryInfo);
        }

      }).catch(err => { })
    },
    getProvince(countryInfo) {
      let that = this;
      app.$api('dict_post_Destination_GetChildList', { Id: countryInfo.ID }).then(res => {
        this.setData({
          provinceList: res,
          cityList: [],
        })
        let index = that.data.index[1]; 
        if (res.length > 0) {
          let proInfo = that.data.provinceList[index];
          that.getCity(proInfo)
        } else {
          that.data.selectInfo.name = that.data.countryList[index].Name;
          that.data.selectInfo.id = that.data.countryList[index].ID;
        }
        that.setData({
          selectInfo: that.data.selectInfo
        })

      }).catch(err => { })

    },
    getCity(proInfo) {
      let that = this;
      app.$api('dict_post_Destination_GetChildList', { Id: proInfo.ID }).then(res => {
        this.setData({
          cityList: res
        })
        if(res.length==0){
          let index = that.data.index[1]; 
          that.data.selectInfo.name = that.data.provinceList[index].Name;
          that.data.selectInfo.id = that.data.provinceList[index].ID;
          
        }else{
          that.data.selectInfo.name = that.data.cityList[index].Name;
          that.data.selectInfo.id = that.data.cityList[index].ID;
        }
        that.setData({
          selectInfo: that.data.selectInfo
        })

      }).catch(err => { })

    },
    changeCountry(e) {
      let that = this;
      const val = e.detail.value
      let arrbefore=that.data.index;
      if (arrbefore[0] == val[0] && arrbefore[1] == val[1] && arrbefore[2] != val[2]){
        let index = val[2];
        that.data.selectInfo.name = that.data.cityList[index].Name;
        that.data.selectInfo.id = that.data.cityList[index].ID;
        this.setData({
          index: val,
          selectInfo: that.data.selectInfo
        })
      }else{
        this.setData({
          index: val,
          countryID: this.data.countryList[val[0]]
        })
        that.getProvince(that.data.countryID);
      }
      

    },
    closeCountry(e) {
      let country = e.target.dataset.self;
      if (country == "country") {
        this.triggerEvent('closeCountryView', " ")
      }

    },
    selectCity(){
      let that=this;
      this.triggerEvent('closeCountryView', " ")
      this.triggerEvent('selectCity', that.data.selectInfo)
    },
  }
})
