// pages/GroupTour/FillOrder/FillOrder.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    payInfo: {},
    data: {
      teamType:0,
    },
    contact: {
      ContactMobile: "",
      ContactName: "",
    },
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let payInfo = wx.getStorageSync('payInfo');
    this.setData({
      payInfo: payInfo
    })
    let that = this;
    let msg = {};
    if (options) {
      // console.log("options", options)
      msg.configId = decodeURIComponent(options.idDes);
      msg.tcid = options.tcid;
      if (options.teamType) {
        msg.teamType = options.teamType;
        that.data.teamType = options.teamType;
      }
      that.data.teamType = options.teamType;
      cityId: that.data.cityId,
        that.setData({
          msg: msg,
        teamType: that.data.teamType
        })
      this.getData(msg);
    }



  },
  getData(msg) {
    let that = this;
    app.$api('b2b_get_GetB2BTravelInfoV1', msg).then(res => {
      let data = res;
      that.setData({
        data: res,
      })
    }).catch(err => {

    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },
  Name(e) {
    this.data.payInfo.ContactName = e.detail.value;
    this.setData({
      payInfo: this.data.payInfo
    })
  },
  Mobile(e) {
    let that = this;
    let phoneNumber = e.detail.value;
    that.data.payInfo.ContactMobile = e.detail.value;
    if (phoneNumber.length==11){
      let checkedNum = that.checkPhoneNum(phoneNumber);
    }
    that.data.payInfo.ContactMobile = phoneNumber;
    that.setData({
      payInfo: that.data.payInfo
    })
  },

  checkPhoneNum(phoneNumber) {
    let str = /^1\d{10}$/;
    if (str.test(phoneNumber)) {
      return true
    } else {
      wx.showToast({
        title: '手机号不正确',
        duration: 500,
        icon: 'none',
      })
      return false
    }
  },

  StartYd() {
    let that = this;
    if (that.data.payInfo.ContactMobile == "" || !that.data.payInfo.ContactMobile || that.data.payInfo.ContactMobile.length<11) {
      wx.showToast({
        title: "请输入正确的手机号",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (that.data.payInfo.ContactName == "" || !that.data.payInfo.ContactName) {
      wx.showToast({
        title: "请输入联系人姓名",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    app.$api('sellorder_post_SetOrderInfoForB2B', that.data.payInfo).then(res => {
      let data = res;
      if (res.resultCode == 1) {
        wx.navigateTo({
          url: '/pages/member/orderCenter/orderCenter?index=1',
        })
      }
    }).catch(err => {

    })

  },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})