// pages/GroupTour/GroupList/GroupList.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    StopResh: false,
    dates: [],
    startCityList: [],
    datecount: [],
    //显示默认天数
    showDays: -1,
    ckedStartCity: 0,
    listmsg: {
      cityId: "262",
      companyId: 0,
      endDate: "",
      lineId: 0,
      lineTeamId: 0,
      maxPrice: -1,
      maxTripDay: -1,
      minPrice: -1,
      minTripDay: -1,
      orderByDate: 2,
      orderByPrice: 0,
      orderBySales: 0,
      pageIndex: 1,
      pageSize: 20,
      priceOrderByField: 2,
      searchKey: "本州大阪.东京",
      startCityId: 0,
      startDate: ""
    },
    ScreenStatus: false,
    dataList: [],
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId
    },
    isLogin: app.isLogin,
    orderType: 0,
    orderindex: 1
  },
  // 最近3个月
  loadDates() {
    let dates = [];
    let d = new Date().getMonth();
    for (let i = 0; i < 3; i++) {
      d++;
      d = d > 12 ? d - 12 : d;
      let obj = {
        id: d,
        name: d + "月"
      }
      dates.push(obj);
    }
    this.setData({
      dates: dates
    })
  },
  // PXClick() {
  //   this.setData({
  //     StopResh: true,
  //   })
  // },
  ClosePXView(e) {
    if (e.target.dataset.target == "self") {
      this.setData({
        StopResh: false,

      })
    }
  },
  ChangeSite(val) {
    this.data.listmsg.companyId = val.companyId;
    this.data.listmsg.cityId = val.cityId;
    this.setData({
      site: val.detail
    })
    this.getList();
  },
  // 获取行程天数及出发城市
  GetStartInfo() {
    let tagmsg = {
      companyId: this.data.site.companyId,
      cityId: this.data.site.cityId,
    }
    app.$api('b2b_get_GetGroupSearchItem', tagmsg).then(res => {
      res.startCity.unshift({
        id: 0,
        startCityName: '不限'
      })
      this.setData({
        startCityList: res.startCity,
        datecount: res.tripDay
      })
    }).catch(err => { })
  },
  //价格区间输入框改变
  bindKeyInput: function (e) {
    if (e.target.dataset.type == 1) {
      this.data.listmsg.minPrice = e.detail.value;
      this.setData({
        listmsg: this.data.listmsg
      })
    } else {
      this.data.listmsg.maxPrice = e.detail.value;
      this.setData({
        listmsg: this.data.listmsg
      })
    }
  },
  //点击行程天数
  getTripDay(e) {
    this.data.listmsg.maxTripDay = e.target.dataset.id;
    this.setData({
      listmsg: this.data.listmsg,
      showDays: e.target.dataset.id
    })
  },
  //点击月份的到出发结束日期
  getStartMonth(e) {
    let year = new Date().getFullYear();
    let month = e.target.dataset.type;
    let firstdate = year + '-' + month + '-01';
    let day = new Date(year, month, 0);
    let lastdate = year + '-' + month + '-' + day.getDate();//获取当月最后一天日期    

    this.data.listmsg.startDate = firstdate;
    this.data.listmsg.endDate = lastdate;
    this.setData({
      listmsg: this.data.listmsg
    })
  },
  //给日期赋值
  bindDateChange(e) {
    if (e.target.dataset.type == 1) {
      this.data.listmsg.startDate = e.detail.value;
    } else {
      this.data.listmsg.endDate = e.detail.value;
    }
    this.setData({
      listmsg: this.data.listmsg
    })
  },
  //点击过滤条件
  changeOrderType(e) {
    let type = e.target.dataset.type;
    if (this.data.orderindex == type) {
      this.data.ordertype = this.data.ordertype == 0 ? 1 : 0
    } else {
      this.data.orderindex = type
      this.data.ordertype = 0
    }
    this.setData({
      orderindex: this.data.orderindex,
      ordertype: this.data.ordertype
    })
    this.getList();
  },

  //点击确定查询数据
  getList() {
    let that = this;
    that.data.listmsg.companyId = that.data.site.companyId;
    that.data.listmsg.cityId = that.data.site.cityId;
    if (this.data.isLogin == 1) {
      this.data.listmsg.priceOrderByField = 2;
    } else {
      this.data.listmsg.priceOrderByField = 4;
    }
    this.data.listmsg.orderByDate = this.data.orderindex == 1 ? (this.data.ordertype == 0 ? 2 : 1) : 0;
    this.data.listmsg.orderByPrice = this.data.orderindex == 2 ? (this.data.ordertype == 0 ? 2 : 1) : 0;
    this.data.listmsg.orderBySales = this.data.orderindex == 3 ? (this.data.ordertype == 0 ? 2 : 1) : 0;
    this.setData({
      listmsg: that.data.listmsg
    })
    app.$api('b2b_get_GetB2BTravelPageList', that.data.listmsg).then(res => {
      res.pageData.forEach(x => {
        x.newImgCover = JSON.parse(x.imgCover);
      })
      this.setData({
        dataList: res.pageData,
        ScreenStatus: false
      })
    }).catch(err => { })
  },
  //点击重置
  resetMsg() {
    this.data.listmsg.startDate = '';
    this.data.listmsg.endDate = '';
    this.data.listmsg.maxTripDay = -1;
    this.data.showDays = -1;
    this.data.listmsg.minPrice = -1;
    this.data.listmsg.maxPrice = -1;
    this.setData({
      listmsg: this.data.listmsg,
      showDays: this.data.showDays
    })
    this.getList();
  },
  //点击出发城市
  getStartCity(e) {
    this.data.listmsg.startCityId = e.target.dataset.id;
    this.data.ckedStartCity = e.target.dataset.index;
    this.setData({
      listmsg: this.data.listmsg,
      ckedStartCity: this.data.ckedStartCity
    })
    this.getList();
  },
  //跳转至详情
  Godetail(e) {
    let item = e.currentTarget.dataset;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.id) + "&tcid=" + item.tcid + "&teamType=0",
    })
  },
  ScreenOpen() {
    this.setData({
      ScreenStatus: true,
    })
  },
  CloseScreen(e) {
    if (e.target.dataset.target == "self") {
      this.setData({
        ScreenStatus: false,

      })
    }
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that=this;
    if (options.lineId){
      that.data.listmsg.lineId=options.lineId;
      that.setData({
        listmsg: that.data.listmsg,
      })
    }
    
    this.GetStartInfo();
    let City = this.selectComponent("#CityComp");
    City.getCityList();

    //初始化数据
    this.getList();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    this.loadDates();
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})
