// pages/GroupTour/GroupTour.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    indicatorDots: true,
    vertical: false,
    autoplay: false,
    circular: false,
    interval: 2000,
    duration: 500,
    previousMargin: 0,
    nextMargin: 0,

    tiaoshui: [],
    isLogin: app.isLogin,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    lineList: [],
    toView: '',
    dataList: [],
    arrlist: [],
    windowHeight: 100 +'px',
    scrollHeight: 'auto',
    fixedNav:false,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let that = this;
    let City = this.selectComponent('#CityComp');
    City.getCityList();


    wx.getSystemInfo({
      success: function(res) {
        that.setData({
          windowHeight: res.windowHeight+'px'
        });
      }
    });
    this.loadTiaoshui();
    this.LineTeam();

  },
  Godetail(e){
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.idDes) + "&tcid=" + item.tcid + "&teamType=0",
    })


  },
  GodetailList(e){
    let item = e.currentTarget.dataset.item;
    console.log(item)
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.id) + "&tcid=" + item.tcid + "&teamType=0",
    })
  },
  Gourl(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupList/GroupList?lineId=' + item.lineId,
    })
  },
  ChangeSite(val) {
    console.log(val.detail);
    this.setData({
      site: val.detail
    })
    this.onLoad();
  },
  Scrolltap(e) {
    let color = e.target.dataset.index;
    this.setData({
      scrollHeight: this.data.windowHeight,

    })
    this.setData({
      toView: color, 
      
    })
  },
  // 获取线路系列列表数据
  GetLoadList(sno) {
    let that = this;
    if (sno < that.data.lineList.length) {
      let msg = {
        pageIndex: 1,
        pageSize: 4,
        companyId: that.data.site.companyId,
        lineId: that.data.lineList[sno].lineId,
        lineTeamId: 0
      }
      app.$api('b2b_get_GetB2BHomeLineTravelPageList', msg).then(res => {
        let obj = {
          lineName: that.data.lineList[sno].lineName,
          lineId: that.data.lineList[sno].lineId,
          LineList: [],
        }
        obj.LineList.push(res.pageData);
        that.data.dataList.push(obj);
        that.setData({
          dataList: that.data.dataList
        })
        this.GetLoadList(sno + 1)
      }).catch(err => {})
    } else {

      let dataList = that.data.dataList;
      dataList.forEach(item => {
        item.LineList[0].forEach(line => {
          if (line.imgCover) {
            line.imgCover = JSON.parse(line.imgCover);
          }
        })
      })
      that.setData({
        dataList: dataList
      })

    }


  },

  LineTeam() {
    let that = this;
    let msg = {
      companyId: that.data.site.companyId,
      cityId: that.data.site.cityId
    }
    app.$apiJavaNew('/api/b2b/group/getHomeLineSort', msg).then(res => {

      that.setData({
        lineList: res,
        dataList: [],
        arrList: []
      })
      console.log("lineList", that.data.lineList)
      this.GetLoadList(0);
    }).catch(err => {

    })
  },
  loadTiaoshui() {
    let that = this;
    let msg = {
      pageIndex: 1,
      pageSize: 4,
      groupRecommendType: 1,
      companyId: that.data.site.companyId,
      cityId: that.data.site.cityId
    }
    app.$apiJavaNew('/api/b2b/group/getHomeRecommendPrice', msg).then(res => {

      that.setData({
        tiaoshui: res.pageData
      })
      console.log(that.data.tiaoshui)
    }).catch(err => {

    })
  },
  onPageScroll: function(e) {
    let that=this;
    // console.log(e);//{scrollTop:99}
    let query = wx.createSelectorQuery();
    //选择id
    query.select('#scrollView').boundingClientRect()
    query.exec(function(res) {
      if (res[0].top<30){
        that.setData({
          fixedNav: true,
          scrollHeight:that.data.windowHeight
        })
      }else{
        that.setData({
          fixedNav: false,
          scrollHeight:"auto"
        })
      }
      
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})