// pages/Home/home.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    background: ["http://imgfile.oytour.com/New/Upload/Cloud/2019-06/20190626103242285.png","http://imgfile.oytour.com/New/Upload/Cloud/2019-07/20190704061255480.jpg"],
    homeTravelSpecialSale:[],
    specialAirTicketItem:[],
    isLogin:0,
    ScrollView: '',
    Scrollindex:0,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    gentuanList:[],
    freeList:[],
    scenList:[],
    localList:[],
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    
    this.setData({
      isLogin: app.isLogin,
    })
    let City = this.selectComponent('#CityComp');
    City.getCityList();
    this.GetGroup();
    this.GetCZTM();
    this.GetAllTicket();
    this.getFree();
    this.getScen();
    this.getLocal()
  },
  ChangeSite(val){
    console.log(val.detail);
    this.setData({
      site: val.detail
    })
    this.onLoad();
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },
  login(){
    wx.navigateTo({
      url: '/pages/login/login',
    })
  },
  goTicket(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/local/TicketDetails/TicketDetails?idDes=' + encodeURIComponent(item.idDes),
    })
  },

  goGroup(e){
    let item = e.currentTarget.dataset.item;
    let teamType = e.currentTarget.dataset.teamtype;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.idDes) + "&tcid=" + item.tcid + "&teamType=" + teamType,
    })
  },

  goMore(e){
    let url=e.target.dataset.url;
    wx.navigateTo({
      url: url,
    })
  },
  Scroll(e){
    this.setData({
      ScrollView: e.target.dataset.id,
      Scrollindex: e.target.dataset.index,
    })
  },
  // 当地游
  getLocal() {
    let Msg = {
      fromOrigin: 1,
      pageIndex: 1,
      pageSize: 4,
    };
    let that = this;
    app.$apiJavaNew('/api/b2b/home/getHomeDayTripPrice', Msg).then(res => {

      that.setData({
        localList: res.pageData
      })
    }).catch(err => {

    })
  },
  // 景点门票
  getScen() {
    let Msg = {
      fromOrigin: 1,
      pageIndex: 1,
      pageSize: 4,
    };
    let that = this;
    app.$apiJavaNew('/api/b2b/home/getHomeTicketCoupons', Msg).then(res => {

      that.setData({
        scenList: res.pageData
      })
    }).catch(err => {

    })
  },
  // 自由行
  getFree() {
    let Msg = {
      fromOrigin: 1,
      teamType: 1,
      pageIndex: 1,
      pageSize: 4,
    };
    let that = this;
    app.$apiJavaNew('/api/b2b/home/getHomeTravelPrice', Msg).then(res => {

      that.setData({
        freeList: res.pageData
      })
    }).catch(err => {

    })
  },
  // 跟团游
  GetGroup() {
    let Msg = {
      fromOrigin:1,
      teamType: 0,
      pageIndex: 1,
      pageSize: 4,
    };
    let that = this;
    app.$apiJavaNew('/api/b2b/home/getHomeTravelPrice', Msg).then(res => {
      
      that.setData({
        gentuanList: res.pageData
      })
    }).catch(err => {
      
    })
  },
  // 超值特卖
  GetCZTM() {
    let that=this;
    let Msg = {
      companyId: that.data.site.companyId,
      cityId: that.data.site.cityId,
      pageIndex: 1,
      pageSize: 5,
    };
    app.$apiJavaNew('/api/b2b/home/getHomeTravelSpecialSale', Msg).then(res => {
      that.setData({
        homeTravelSpecialSale: res.pageData
      })

    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  // 特价机票
  GetAllTicket() {
    let Msg = {
      airTicketType: 0,
      pageIndex: 1,
      pageSize: 2,
    };
    let that = this;
    app.$apiJavaNew('/api/b2b/home/getHomeSpecialAirTicketList', Msg).then(res => {
      
      that.setData({
        specialAirTicketItem: res.pageData
      })

    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})