// pages/Ticket/Ticket.js
let app = getApp();
var util = require('../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    types: [{
      id: 0,
      name: '头等舱'
    }, {
      id: 1,
      name: '商务舱'
    }, {
      id: 2,
      name: '经济舱'
    }],
    index: 0,//初始化数据
    items: [
      { name: '0', value: '携带儿童' },
      { name: '1', value: '携带婴儿', checked: 'true' }
    ],
    dataList: [],
    isLogin: app.isLogin,
    msg: {
      pageIndex: 1,
      pageSize: 10,
      id: 0,
      qFlightDateStart: util.YYMMDD(new Date()),
      qFlightDateEnd: "",
      flight_number: "",
      airLineID: 0,
      ticketType: 2,
      lineId: 0,
      isPayOrder: 0,
      departure_city: 0,
      departure_cityname: "",
      arrival_city: 0,
      arrival_cityname: "",
      freightSpace: 0,
      airTicketScatterNum: 0,
      cr: 0,
      child: 0,
      ye: 0,
      lr: 0
    },
    countryHidden:false,
    type:'',
  },
  bindPickerChange: function (e) {
    console.log('picker发送选择改变，携带值为', e.detail.value)
    this.setData({
      index: e.detail.value
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.getJXTH();
    let chooseCity = this.selectComponent('#chooseCity');
    chooseCity.getCountry();
  },
  getCity(e) {
    let that = this;
    that.setData({
      countryHidden: true
    })
    let type = e.target.dataset.type;
    that.setData({
      type: type
    })
  },
  selectCity(val) {
    let that = this;
    let vastr = val.detail;
    if (that.data.type == "start") {
      that.data.msg.departure_city = vastr.id;
      that.data.msg.departureName = vastr.name;

    } else {
      that.data.msg.arrival_city = vastr.id;
      that.data.msg.arrivalName = vastr.name;
    }
    that.setData({
      msg: that.data.msg
    })
  },
  closeCountryView() {
    this.setData({
      countryHidden: false,
    })
  },
  bindDateChange(e){
    this.data.msg.qFlightDateStart= e.detail.value
    this.setData({
      msg:this.data.msg
    })
  },
  getJXTH() {
    let msg = {
      isDiscounts: 1,
      pageIndex: 1,
      pageSize: 4
    };
    app.$apiJavaNew('/api/dmc/airticket/getB2BAirticketList', msg).then(res => {
      this.setData({
        dataList: res.pageData
      })
    }).catch(err => {

    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})