// pages/Voucher/VoucherDetails/VoucherDetails.js
let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    nameID: '',
    orderId: null,
    tcId: null,
    GuestId: null,
    leaderData: {},
    voucherData: {},
    rating: '',
    Message: '', 
    showYouJi: false,
    showBadYouJi: false
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let info = wx.getStorageSync('info'),
      orderId = options.orderId,
      tcId = options.tcId;
    this.setData({
      nameID: info.nameID,
      GuestId: info.ID,
      orderId: orderId,
      tcId: tcId
    })
    this.getinfo()
    this.getVoucher()
  },
  // 差评直接退出小程序
  logOut: function () {
    wx.reLaunch({
      url: '../Voucher?finish=true',
    })
  },
  // 保存数据
  saveMessage: function () {
    this.setData({ 
      voucherData: this.data.voucherData
    }) 
    let data = JSON.parse(JSON.stringify(this.data.voucherData)),
      showYouJi = true;
    data.forEach(x=>{
      x.TCID = this.data.tcId;
      x.OrderID = this.data.orderId;
      x.GuestId = this.data.GuestId;
      if (x.SurveyType === 2 || x.SurveyType === 3) {
        x.SurveyOptionsList.forEach(y=>{
          y.IsCheck = y.IsCheckS ? '1' : '0'
        })
      }
      if (x.SurveyType === 1 && x.ScoreNum < 3) {
        showYouJi = false
      }
    })
    if (this.data.Message === '') {
      wx.showToast({
        title: '请填写留言',
        icon: 'none',
        duration: 1000
      })
      return
    }
    app.$api('survey_post_SetGuestSurvey', data).then(res => {
      if (showYouJi) {
        this.setData({
          showYouJi: true
        }) 
      } else {
        this.setData({
          showBadYouJi: true
        }) 
      }
      wx.showToast({
        title: '提交成功！',
        icon: 'none',
        duration: 1000
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  //写游记
  goWrite: function () {
    wx.navigateTo({
      url: '/pages/Voucher/write/write?GuestId=' + this.data.GuestId + '&orderId=' + this.data.orderId + '&tcId=' + this.data.tcId
    })
  },
  //评分
  handleChange: function (e) {
    let index = e.target.id
    this.data.voucherData[index].ScoreNum = e.detail.value
    this.setData({
      voucherData: this.data.voucherData,
      rating: e.detail.value
    })
  },
  // 输入留言
  inputMessage: function (e) {
    let index = e.target.id
    this.data.voucherData[index].TextContent = e.detail.value
    this.setData({
      voucherData: this.data.voucherData,
      Message: e.detail.value
    })
  },
  //获取领队导游信息
  getinfo: function () {
    let data = {
      tcid: this.data.tcId
    }
    app.$api('miniProgram_post_GetBasePrice', data).then(res => {
      console.log(res)
      this.setData({
        leaderData: res
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  checkboxChange: function (e) {
    let ID = [],checkd = e.detail.value,index = e.target.id;
    for (let i = 0; i < checkd.length ; i++) {
      ID.push(Number(checkd[i]))
    }  
    this.data.voucherData[index].SurveyOptionsList.forEach(o=>{
      o.IsCheckS = false
      ID.forEach(i=>{
        if (i === o.ID) {
          o.IsCheckS = true
        }
      })
    })
    this.setData({
      voucherData: this.data.voucherData
    })
  },
  radioChange: function (e) { 
    let ID = Number(e.detail.value),index = e.target.id; 
    this.data.voucherData[index].SurveyOptionsList.forEach(o => { 
      if (ID === o.ID) {
        o.IsCheckS = true
      } else {
        o.IsCheckS = false
      }
    }) 
    this.setData({
      voucherData: this.data.voucherData
    }) 
  },
  // 获取问券列表
  getVoucher: function () {
    let data = {
      IsShow: 1,
      SurveyType: -1
    }
    app.$api('survey_post_GetSurveyShowList', data).then(res => {
      console.log(res)
      res.map(item => {
        if (item.SurveyType === 2) {
          item.SurveyOptionsList.map((cItem, cIndex) => {
            // if (cIndex === 0) {
            //   cItem.IsCheckS = true
            // } else {
              cItem.IsCheckS = false
            // }
          })
        }
        if (item.SurveyType === 3) {
          item.SurveyOptionsList.map((cItem, cIndex) => {
            cItem.IsCheckS = false
          })
        }
        if (item.SurveyType === 1) {
          item.ScoreNum = 5;
        }
      })
      this.setData({
        voucherData: res
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})