// pages/Voucher/write/write.js
let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    orderId: null,
    tcId: null,
    GuestId: null,
    imgList: [],
    tag: [],
    infoMessage: '',
    showBadYouJi: false,
    tag2: [],
    ActivateCode: '166666666',
  },
  copyText: function (e) {
    
    let _this = this
    wx.setClipboardData({
      data: _this.data.ActivateCode,
      success: function (res) {
        wx.getClipboardData({
          success: function (res) {
            wx.showToast({
              title: '复制成功'
            })
          }
        })
      }
    })
  },
  // 退出
  logOut: function () {
    wx.reLaunch({
      url: '../Voucher?finish=true',
    })
  },
  //提交游记内容数据
  goWrite: function () {
    let msg = {
      GuestId: this.data.GuestId,
      TCID: this.data.tcId,
      OrderID: this.data.orderId,
      GuestTravelLableList: [],
      NotesPics: this.data.imgList,
    };
    if (this.data.infoMessage !== '') {
      msg.GuestTravelLableList.push({
        Name: '',
        Content: this.data.infoMessage
      })
    }
    this.data.tag.map(x=>{
      console.log('x.Content', x.Content)
      if (x.Content !== '') {
        msg.GuestTravelLableList.push(x)
      }
    })
    this.setData({
      tag: this.data.tag2
    })
    app.$api('survey_post_SetGuestTravelNotes', msg).then(res => {
      if (res.Id > 0) {
        this.setData({
          ActivateCode: res.ActivateCode,
        })
      }
      this.setData({
        showBadYouJi: true,
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  // 正文内容
  inputMessage: function (e) {
    this.setData({
      infoMessage: e.detail.value
    })
  },
  // 标签内容
  inputItemMessage: function (e) {
    let index = e.target.id
    this.data.tag[index].Content = e.detail.value
    this.setData({
      tag: this.data.tag
    })
  },
  //选择标签
  clickTag: function (e) {
    let index = e.target.id
    this.data.tag[index].Content = '';
    this.data.tag[index].click = !this.data.tag[index].click
    this.setData({
      tag: this.data.tag
    })
  },
  // 删除图片
  deleteImg: function (e) {
    let index = e.target.id
    this.data.imgList.splice(index, 1)
    this.setData({
      imgList: this.data.imgList
    })
  },
  // 选择图片
  chooseImage: function () {
    let _this = this,
      path = '/Upload/DMC/';
    wx.chooseImage({
      count: 9,
      sizeType: ['original', 'compressed'],
      sourceType: ['album', 'camera'],
      success(res) {
        let arr = _this.data.imgList
        const tempFilePaths = res.tempFilePaths
        res.tempFilePaths.map(x=>{
          if (arr.length >= 9) {
            wx.showToast({
              title: '最多上传9张图片！',
              icon: 'none',
              duration: 1000
            })
            return
          }
          wx.uploadFile({
            url: 'http://upload.oytour.com/Upload?filePath=' + path, //仅为示例，非真实的接口地址
            filePath: x,
            name: 'file',
            formData: {
              'user': x
            },
            success: function (res) {
              var data = JSON.parse(res.data) 
              arr.push("http://imgfile.oytour.com"+data.FilePath)
              _this.setData({
                imgList: arr
              })
            }
          })
        })
      }
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    //修改title
    wx.setNavigationBarTitle({
      title: '写游记，领奖品'
    })
    this.setData({
      orderId: options.orderId,
      tcId: options.tcId,
      GuestId: options.GuestId,
    })
    this.getTag()
  },
  getTag: function () {
    let _this = this;
    app.$api('survey_post_GetGuestTravelLableList', {}).then(res => {
      let arr = [];
      res.forEach((x, i)=>{
        arr.push(
          {
            id: i,
            Name: x,
            Content: '',
            click: false
          }
        )
      })
      _this.setData({
        tag: arr,
        tag2: JSON.parse(JSON.stringify(arr))
      })
      console.log(this.data.tag)
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})