// pages/freeTravel/PersonalTailor/PersonalTailor.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    value: [0, 0],
    countryHidden: false,
    msg: {
      customId: 0,
      startDate: "",
      budget: "",
      audltNumber: 0,
      childrenNumber: 0,
      contact: '',
      phoneNumber: '',
      email: '',
      weChat: '',
      desc: '',
      departureName: "",
      destinationIds: "",
      destinationNames: '',
      provideItem: '线路设计',
      otherDemand: "",
      backDate: "",
    },

    type: "",
    peopleNumber: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    peopleNumber1: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    numberHidden: false,
    active: [{
        lable: '线路设计',
        id: 0,
        click: true,
      },
      {
        lable: '机票',
        id: 1,
        click: false,
      },
      {
        lable: '酒店',
        id: 2,
        click: false,
      },
      {
        lable: '用车',
        id: 3,
        click: false,
      },
      {
        lable: '用餐',
        id: 4,
        click: false,
      }
    ],
    proHidden: false,
    orderState: false,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let chooseCity = this.selectComponent('#chooseCity');
    chooseCity.getCountry();
  },
  goOrder(){
    wx.navigateTo({
      url: '/pages/member/orderCenter/orderCenter?index=2',
    })
  },
  submitMsg() {
    let that = this;
    let msg = that.data.msg;
    if (msg.departureName == "") {
      wx.showToast({
        title: "请选择出发地",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (msg.destinationNames == "") {
      wx.showToast({
        title: "请选择目的地",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (msg.startDate == "") {
      wx.showToast({
        title: "请选择出行日期",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (msg.audltNumber + msg.childrenNumber < 1) {
      wx.showToast({
        title: "出行人数至少一人！",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (msg.contact == "") {
      wx.showToast({
        title: "请填写联系人姓名",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    if (msg.phoneNumber == "") {
      wx.showToast({
        title: "请填写联系人手机号",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    app.$apiJavaData('/api/b2b/free/setTravelCusotom', msg).then(res => {
      if (res.resultCode == 1) {
        this.setData({
          orderState: true,

        })
      } else {
        wx.showToast({
          title: res.message,
          icon: 'none',
          duration: 1000
        })
      }
    }).catch(err => {})
  },
  proView() {
    this.setData({
      proHidden: true,
    })
  },
  closePro(e) {
    let self = e.target.dataset.self;
    if (self == "self") {
      this.setData({
        proHidden: false,
      })
    }
  },
  protext(e) {
    let item = e.currentTarget.dataset.item;
    let index = item.id;
    this.data.active[index].click = !this.data.active[index].click;
    this.setData({
      active: this.data.active,
    })
    let arr = [];
    this.data.active.forEach(item => {
      if (item.click) {
        arr.push(item.lable)
      }
    })

    this.data.msg.provideItem = arr.join(',');
    this.setData({
      msg: this.data.msg,
    })
  },
  otherInput(e) {
    this.data.msg.otherDemand = e.detail.value;
    this.setData({
      msg: this.data.msg
    })
  },
  weixinInput(e) {
    this.data.msg.weChat = e.detail.value;
    this.setData({
      msg: this.data.msg
    })
  },
  emailInput(e) {
    this.data.msg.email = e.detail.value;
    this.setData({
      msg: this.data.msg
    })
  },
  concatPhoneInput(e) {
    this.data.msg.phoneNumber = e.detail.value;
    let phoneNumber = e.detail.value;
    if (phoneNumber.length == 11) {
      let checkedNum = this.checkPhoneNum(phoneNumber);
    }
    this.setData({
      msg: this.data.msg
    })
  },
  checkPhoneNum(phoneNumber) {
    let str = /^1\d{10}$/;
    if (str.test(phoneNumber)) {
      return true
    } else {
      wx.showToast({
        title: '手机号不正确',
        duration: 500,
        icon: 'none',
      })
      return false
    }
  },
  concatNameInput(e) {
    this.data.msg.contact = e.detail.value;
    this.setData({
      msg: this.data.msg
    })
  },
  budgetInput(e) {
    this.data.msg.budget = e.detail.value;
    this.setData({
      msg: this.data.msg
    })

  },
  changePerson(e) {
    let val = e.detail.value;
    let that = this;
    that.data.msg.audltNumber = that.data.peopleNumber[val[0]];
    that.data.msg.childrenNumber = that.data.peopleNumber[val[1]];

  },
  selectPerson() {
    let that = this;
    that.setData({
      msg: that.data.msg,
      numberHidden: false
    })
  },
  closeNumber(e) {
    let str = e.target.dataset.self;
    if (str == "number") {
      this.setData({
        numberHidden: false
      })
    }
  },
  numberView() {
    this.setData({
      numberHidden: true
    })
  },
  selectCity(val) {
    let that = this;
    let vastr = val.detail;
    if (that.data.type == "start") {
      that.data.msg.departureId = vastr.id;
      that.data.msg.departureName = vastr.name;

    } else {
      that.data.msg.destinationIds = vastr.id;
      that.data.msg.destinationNames = vastr.name;
    }
    that.setData({
      msg: that.data.msg
    })
  },
  getCity(e) {
    let that = this;
    that.setData({
      countryHidden: true
    })
    let type = e.target.dataset.type;
    that.setData({
      type: type
    })
  },
  closeCountryView() {
    this.setData({
      countryHidden: false,
    })
  },
  bindDateChange(e) {
    let that = this;
    let str = e.target.dataset.str;
    if (str == "start") {
      that.data.msg.startDate = e.detail.value;
    } else {
      that.data.msg.backDate = e.detail.value;

    }
    this.setData({
      msg: that.data.msg
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})