// pages/freeTravel/freeList/freeList.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    isLogin: app.isLogin,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    dates: [],
    ScreenStatus: false,
    listmsg: {
      minTripDay: -1,
      maxTripDay: -1,
      pageIndex: 1,
      pageSize: 10,
      lineId: 0,
      lineTeamId: 0,
      dayNum: -1,
      monthdate: [],
      priceTag: [],
      startCityId: 0,
      cityId: app.state.cityId,
      startDate: '',
      endDate: '',
      minPrice: -1,
      maxPrice: -1,
      companyId: app.state.companyId,
      priceOrderByField: 0,
      searchKey: '',
      orderByDate:2,
      orderByPrice:0,
      orderBySales:0,

    },
    datalist:[],
    noData: false,
    orderindex:1,
    ordertype: 0,
    lineTeam:[],
    startCity:[],
    tripDay:[],
    dates:[],

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {

    
    let listmsg= this.data.listmsg;
    if (this.data.isLogin == 1) {
      listmsg.priceOrderByField = 2;
    } else {
      listmsg.priceOrderByField = 4;
    }
    this.setData({
      listmsg: listmsg
    })

    let City = this.selectComponent('#CityComp');
    City.getCityList();
    this.getThemeTag();
    this.loadRecoItems();
    this.loadDates();
    this.GetList();
  },
  goGroup(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.id) + "&tcid=" + item.tcid + "&teamType=1",
    })
  },
  ChangeLine(e){
    let that = this;
    that.data.listmsg.lineTeamId = e.target.dataset.id;
    that.setData({
      listmsg: that.data.listmsg
    })

  },
  getCity(e){
    let that = this;
    let id = e.currentTarget.dataset.city;
    that.data.listmsg.startCityId = id;
    that.setData({
      listmsg: that.data.listmsg
    })
  },
  getDay(e){
    let that = this;
    let day = e.currentTarget.dataset.day;
    that.data.listmsg.dayNum=day;
    that.setData({
      listmsg: that.data.listmsg
    })
  },
  GetMonth(e){
    let that = this;
    let month = e.target.dataset.month;
    let num = new Date(month.year, month.id, 0);
    that.data.listmsg.startDate = month.year + "-" + month.month+"-"+"01";
    that.data.listmsg.endDate = month.year + "-" + month.month + "-" + num.getDate();
    that.setData({
      listmsg: that.data.listmsg
    })
  },
  // 获取线路
  loadRecoItems() {

    let that = this;
    app.$api('b2b_get_GetFreeSearchItem', { companyId:that.data.site.companyId}).then(res => {
      
      that.setData({
        lineTeam:res.lineTeam,
        startCity: res.startCity,
        tripDay: res.tripDay
      })
    }).catch(err => { })
  },
  // 最近3个月
  loadDates() {
    let dates = [];
    let d = new Date().getMonth();
    let y = new Date().getFullYear();
    for (let i = 0; i < 3; i++) {
      d++;
      d = d > 12 ? d - 12 : d;
      let month = d < 10 ? "0"+d : d;
      let obj = {
        year:y,
        id: d,
        month: month,
        name: d + "月"
      }
      dates.push(obj);
    }
    this.setData({
      dates: dates
    })
  },
  bindDateChange(e) {
    let type = e.target.dataset.type;
    let listmsg = this.data.listmsg;
    if (type = "start") {
      listmsg.startDate = e.detail.value;
    }else{
      listmsg.endDate = e.detail.value;
    }
    this.setData({
      listmsg: listmsg
    })
  },
  ChangeSite(val) {
    this.setData({
      site: val.detail
    })
    this.loadRecoItems();
    this.GetList();
  },
  ScreenOpen() {
    this.setData({
      ScreenStatus: true,
    })
  },
  CloseScreen(e) {

    if (e.target.dataset.target == "self") {
      this.setData({
        ScreenStatus: false,

      })
    }
  },
  // 获取主题标签
  getThemeTag() {
    let tagmsg = {
      name: 'theme',
      code: 1,
    }
    let that = this;
    app.$api('travel_get_GetTravelPriceTag', tagmsg).then(res => {
      let ThemeTagList = res;
      ThemeTagList.forEach(item => {
        item.show = 0;
      })
      that.setData({
        ThemeTagList: ThemeTagList
      })
    }).catch(err => { })
  },
  // 列表数据
  GetList() {

    let that = this;
    that.setData({
      ScreenStatus: false,
    })
    const datalist = that.data.datalist;
    app.$api('b2b_get_GetB2BFreePageList', that.data.listmsg).then(res => {
      if (res.pageData.length < 10) {
        that.setData({
          noData: true
        })
        
      }else{
        
        res.pageData.forEach(item => {
          item.imgCover = JSON.parse(item.imgCover);
          if (item.priceTags) {
            item.priceTags = item.priceTags.split(",");
          }
          datalist.push(item)
        })
        that.setData({
          datalist: datalist
        })
      }
      wx.hideNavigationBarLoading()

    }).catch(err => { })
  },
  PriceTag(e) {
    let that = this;
    let listmsg = that.data.listmsg;
    let tag = e.target.dataset.tag;
    let index = e.target.dataset.index;
    let priceTag = that.data.listmsg.priceTag;
    let ThemeTagList = that.data.ThemeTagList;
    priceTag = [];
    that.setData({
      listmsg: listmsg
    })

    ThemeTagList.forEach(item => {
      item.SNO = 0;
    })
    if (index != 0) {
      priceTag.push(tag.ID);
      that.data.listmsg.priceTag = priceTag;
      priceTag.forEach(tag => {
        ThemeTagList.forEach(item => {
          if (tag == item.ID) {
            item.SNO = -1;
          }
        })
      })
      that.setData({
        ThemeTagList: ThemeTagList,
        listmsg: listmsg
      })
    }
    that.GetList();
  },
  changeOrderType(e) {
    let type=e.target.dataset.type;
    let orderindex = this.data.orderindex;
    let ordertype = this.data.ordertype;
    let listmsg = this.data.listmsg;
    let orderByDate = this.data.listmsg.orderByDate;
    let orderByPrice = this.data.listmsg.orderByPrice;
    
    if (orderindex == type) {
      orderindex = ordertype == 0 ? 1 : 0
    } else {
      orderindex = type
      ordertype = 0
    }
    this.data.listmsg.orderByDate= orderindex == 1 ? (ordertype == 0 ? 2 : 1) : 0;
    this.data.listmsg.orderByPrice = orderindex == 2 ? (ordertype == 0 ? 2 : 1) : 0;
    this.data.listmsg.orderBySales = orderindex == 3 ? (ordertype == 0 ? 2 : 1) : 0;
    this.setData({
      orderindex: orderindex,
      ordertype: ordertype,
      listmsg: listmsg
    })
    this.GetList()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    let that=this;
    if (that.data.noData) return;
    wx.showNavigationBarLoading();
    let listmsg = that.data.listmsg;
    let pageIndex = that.data.listmsg.pageIndex;
    // 每次下拉 page+1
    pageIndex = pageIndex+1;
    that.data.listmsg.pageIndex = pageIndex;
    this.setData({
      listmsg: listmsg
    })
    this.GetList();
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})