// pages/GroupTour/ChDateNum/ChDateNum.js
let app = getApp();
var util = require('../../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    currentDay: util.YYMMDD(new Date()),
    priceData: [],
    numer: 1,
    monthList: [],
    activeTab: 0,
    isLogin: app.isLogin,

    idDes: "",
    timeStr: {},
    tomonth: util.YYMM(new Date()),
    selectIndex: -1,
    msg:{},
    dateMsg:{},
    singelPrice:0,
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let that = this;
    let msg = wx.getStorageSync('Foodmsg')
    msg.preferPrice=0;
    let dateMsg = wx.getStorageSync('FooddateMsg')
    that.setData({
      msg: msg,
      dateMsg: dateMsg,
    })
    console.log("111", that.data.msg)
    console.log("222", that.data.dateMsg)

    that.getPrice();

  },

// 获取价格
getPrice(){
  let that=this;
  let tomonth = that.data.tomonth;
  let year = tomonth.substr(0, 4)
  let month = tomonth.substr(5, 2)
  let currentMonthDays = util.getDays(year, month);
  let dateMsg=that.data.dateMsg;
  dateMsg.startDate = `${tomonth}-01`;
  dateMsg.endDate = `${tomonth}-${currentMonthDays}`;
  app.$apiJavaNew('/api/b2b/food/getFoodMealPriceList', dateMsg).then(res => {
    console.log(res);
    let data=[];
    res.forEach(item=>{
      let msg={};
      msg.dateStr = item.date;
      msg.startDate = item.date;
      msg.priceId=item.id;
      msg.b2CPrice = item.b2bPrice;
      msg.b2BPrice = item.b2bPrice;
      data.push(msg)
    })
    
    this.setData({
      priceData: data
    })
    this.CreatCalendar();

  }).catch(err => { })
},
  // 改变月份
  changeMonth(e) {
    let num = e.currentTarget.dataset.month;
    let tomonth = util.changeMonth(this.data.tomonth, num);
    let today = util.YYMM(new Date());
    if (!util.CompareDate(tomonth, today)){
      wx.showToast({
        title: "不能选择过去的日期！",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    this.setData({
      tomonth: tomonth,
      currentDay: tomonth
    })
    this.getPrice()
  },
  childrenEvent(e) {
    let that = this;
    let val = e.detail;
    console.log(val);
    that.data.msg.priceId = val.priceId;
    that.data.singelPrice = val.price;
    that.setData({
      selectIndex: val.selectIndex,
      msg: that.data.msg,
      singelPrice: that.data.singelPrice
    })
    this.calcMoney();
  },

  StartYd() {
    let that = this;
    let msg = that.data.msg;
    if (msg.preferPrice ==0) {
      wx.showToast({
        title: "请选择使用日期",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    app.$apiJavaData('/api/b2b/food/setFoodOrder', msg).then(res => {
      console.log(res);
      if (res.resultCode == 1) {
        wx.navigateTo({
          url: '/pages/member/orderCenter/orderCenter?index=3',
        })
      } else {
        wx.showToast({
          title: res.message,
          icon: 'none',
          duration: 1000
        })
      }

    }).catch(err => { })
  },
 
  calcMoney() {
    let that = this;
    let msg = that.data.msg;
    msg.preferPrice = that.data.singelPrice * (msg.adultNum + msg.childNum);
    that.setData({
      msg: msg
    })
  },


  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },
  CreatCalendar() {
    this.calendar = this.selectComponent('#calendar');
    this.calendar.getYearMonthDay();
  },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})