// pages/local/oneday/oneday.js
let app = getApp();
var util = require('../../../utils/util.js')
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    pageIndex: {
      type: 'number'
    },
    searchKey: {
      type: 'String'
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    ScreenStatus: false,
    countryList: [],
    isLogin: app.isLogin,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    msg: {
      pageIndex: 1,
      pageSize: 5,
      startDate: "",
      endDate: "",
      minPrice: -1,
      maxPrice: -1,
      orderByPrice: 0,
      orderBySales: 0,
      cityId: 0,
      searchKey: "",
    },
    cityList: [],
    dataList: [],
    noData: false,
  },

  /**
   * 组件的方法列表
   */
  methods: {
    goUrl(e) {
      let item = e.currentTarget.dataset.item;
      wx.navigateTo({
        url: '/pages/local/LocalFoodDetails/LocalFoodDetails?idDes=' + encodeURIComponent(item.idDes)+"&id="+item.id,
      })
    },
    zhpx() {
      this.data.msg.orderByPrice = 0;
      this.data.msg.orderBySales = 0;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    bySale() {
      let sale = this.data.msg.orderBySales;
      sale == 0 ? sale = 1 : sale = 0;
      this.data.msg.orderByPrice = 0;
      this.data.msg.orderBySales = sale;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    byPrice() {
      let orderByPrice = this.data.msg.orderByPrice;

      orderByPrice == 0 ? orderByPrice = 1 : orderByPrice = 0;
      this.data.msg.orderByPrice = orderByPrice;
      this.data.msg.orderBySales = 0;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    getList() {
      this.data.msg.searchKey = this.data.searchKey;
      this.data.msg.pageIndex = this.properties.pageIndex;
      this.setData({
        msg: this.data.msg
      })
      let dataList = this.data.dataList;
      app.$apiJavaNew('/api/b2b/food/getFoodList', this.data.msg).then(res => {
        console.log("美食", res);

        if (res.pageData.length < 5) {
          this.setData({
            noData: true
          })

        }
        res.pageData.forEach(item => {
          dataList.push(item)
        })
        this.setData({
          dataList: dataList
        })
        this.triggerEvent('oneDayInfo', this.data.noData)

      }).catch(err => { })
    },
    screenOpen() {
      this.setData({
        ScreenStatus: true,
      })
    },
    closeScreen(e) {

      if (e.target.dataset.target == "self") {
        this.setData({
          ScreenStatus: false,

        })
      }
    },
    minPriceInput(e) {
      this.data.msg.minPrice = e.detail.value;
      this.setData({
        msg: this.data.msg
      })
    },
    maxPriceInput(e) {
      this.data.msg.maxPrice = e.detail.value;
      this.setData({
        msg: this.data.msg
      })
    },
    bindDateChange(e) {

      let type = e.currentTarget.dataset.type;
      let val = e.detail.value;
      if (type == "start") {
        this.data.msg.startDate = val;
      } else {
        this.data.msg.endDate = val;
      }
      this.setData({
        msg: this.data.msg
      })
      if (util.CompareDate(this.data.msg.startDate, this.data.msg.endDate)) {
        wx.showToast({
          title: "请选择正确的日期！",
          icon: 'none',
          duration: 1000
        })
      }

    },
    // 获取国家
    getCityItem() {
      app.$apiJavaNew('/api/b2b/food/getFoodCountryCityItem', {}).then(res => {
        console.log("目的地", res)
        this.setData({
          cityList: res
        })

      }).catch(err => { })
    },
  
    getcityId(e) {
      let item = e.currentTarget.dataset.item;
      this.data.msg.cityId = item
      this.setData({
        msg: this.data.msg
      })
    }
  }
})
