// pages/GroupTour/ChDateNum/ChDateNum.js
let app = getApp();
var util = require('../../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    currentDay: util.YYMMDD(new Date()),
    priceData: [],
    numer: 1,
    monthList: [],
    activeTab: 0,
    isLogin: app.isLogin,

    idDes: "",
    timeStr: {},
    tomonth: util.YYMM(new Date()),
    selectIndex: -1,
    msg: {
      useDate: '',
      purchaseQuantity: 1,
      contactEmail: '',
      discountMoney: 0,
      orderSource: 2,
      orderForm: 4,
      couponAllotIds: "",
      customerId: 0,
      price: 0,
      contactCNName: '',
      contactMobile: '',
      contactEmail: "",
      discountMoney: 0,
      couponAllotIds: '',
    },
    SettlementPrice: 0,
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let that = this;
    console.log(options);
    if (options.idDes) {
      that.setData({
        idDes: decodeURIComponent(options.idDes)
      })
    }
    // that.setData({
    //   idDes: decodeURIComponent("tIVL4K8ZOcU%3D%0A")
    // })
    that.getInfo();

  },

  nameInput(e) {
    let val = e.detail.value;
    this.data.msg.contactCNName = val;
    this.setData({
      msg: this.data.msg
    })
  },
  phoneInput(e) {
    let val = e.detail.value;
    this.data.msg.contactMobile = val;
      if (val.length > 11) {    
        wx.showToast({     
          title: '手机号有误',
               icon: 'none',
               duration: 500    
        })   
      }  
    this.setData({
      msg: this.data.msg
    })
  },
  emailInput(e) {
    let val = e.detail.value;
    this.data.msg.contactEmail = val;
    this.setData({
      msg: this.data.msg
    })
  },



  // 改变月份
  changeMonth(e) {
    let num = e.currentTarget.dataset.month;
    let tomonth = util.changeMonth(this.data.tomonth, num)
    let today = util.YYMM(new Date());
    if (!util.CompareDate(tomonth, today)) {
      wx.showToast({
        title: "不能选择过去的日期！",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    this.setData({
      tomonth: tomonth
    })
    this.getCurrentDays()
  },
  childrenEvent(e) {
    let that = this;
    let val = e.detail;
    that.data.msg.useDate = val.ymd;
    that.data.msg.couponsId = val.couponsId;
    that.data.msg.ticketId = val.ticketId;
    that.data.msg.priceId = val.priceId;
    that.data.msg.price = val.price;
    that.setData({
      selectIndex: val.selectIndex,
      msg: that.data.msg
    })
    this.calcMoney();
  },
  //   获取当月天数
  getCurrentDays() {
    let that = this;
    let MonthdayList = [];
    let tomonth = that.data.tomonth;
    let year = tomonth.substr(0, 4)
    let month = tomonth.substr(5, 2)
    that.data.currentMonthDays = util.getDays(year, month)
    for (let i = 1; i <= that.data.currentMonthDays; i++) {
      if (i < 10) {
        i = `0${i}`;
      }
      let month = {};
      month.dateStr = `${that.data.tomonth}-${i}`;
      MonthdayList.push(month)
    }
    let DayList = [];
    let len = that.data.timeStr.length;
    MonthdayList.forEach(item => {
      if (util.CompareDate(MonthdayList[0].dateStr, that.data.timeStr[len - 1].endDate)) {
        let msg = {
          dateStr: item.dateStr,
          startDate: item.dateStr,
        };
        DayList.push(msg)

      }

      this.data.timeStr.forEach(time => {
        if (util.CompareDate(item.dateStr, time.startDate) && util.CompareDate(time.endDate, item.dateStr)) {
          let msg = {
            b2CPrice: time.b2bPrice,
            b2BPrice: time.b2bPrice,
            couponsId: time.couponsId,
            priceId: time.id,
            idDes: time.idDes,
            ticketId: time.ticketId,
            dateStr: item.dateStr,
            startDate: item.dateStr,
          };
          DayList.push(msg)
        }

      })
      if (that.data.timeStr.length < 1) {
        let msg = {
          dateStr: item.dateStr,
          startDate: item.dateStr,

        };
        DayList.push(msg)

      }
    })
    that.setData({
      priceData: DayList,
      currentDay: that.data.tomonth
    })
    this.CreatCalendar();

  },
  getInfo() {
    app.$apiJavaNew('/api/b2b/scenic/getCouponsTicketPriceList', {
      idDes: this.data.idDes
    }).then(res => {
      // console.log(res);
      this.setData({
        timeStr: res
      })
      this.getCurrentDays();

    }).catch(err => {})
  },
  StartYd() {
    let that = this;
    let msg = that.data.msg;
    if (msg.useDate == "") {
      wx.showToast({
        title: "请选择使用日期",
        icon: 'none',
        duration: 1000
      })
      return;
    }
    app.$apiJavaData('/api/b2b/scenic/setTicketOrder', msg).then(res => {
      if (res.resultCode == 1) {
        wx.navigateTo({
          url: '/pages/member/orderCenter/orderCenter?index=3',
        })
      } else {
        wx.showToast({
          title: res.message,
          icon: 'none',
          duration: 1000
        })
      }

    }).catch(err => {})
  },
  subtract() {
    let purchaseQuantity = this.data.msg.purchaseQuantity;
    purchaseQuantity > 0 ? purchaseQuantity-- : 0;
    this.data.msg.purchaseQuantity = purchaseQuantity
    this.setData({
      msg: this.data.msg
    })
    this.calcMoney();
  },
  add() {
    let purchaseQuantity = this.data.msg.purchaseQuantity;
    purchaseQuantity = ++purchaseQuantity;
    this.data.msg.purchaseQuantity = purchaseQuantity
    this.setData({
      msg: this.data.msg
    })
    this.calcMoney();
  },
  inputPurchase(e) {
    let val = e.detail.value;
    this.data.msg.purchaseQuantity = val;
    this.setData({
      msg: this.data.msg
    })
    this.calcMoney();
  },
  calcMoney() {
    let that = this;
    let msg = that.data.msg;
    let SettlementPrice = msg.price * Number(msg.purchaseQuantity);
    that.setData({
      SettlementPrice: SettlementPrice
    })
  },


  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },
  CreatCalendar() {
    this.calendar = this.selectComponent('#calendar');
    this.calendar.getYearMonthDay();
  },
  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})