// pages/freeTravel/freeList/freeList.js
let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    isLogin: app.isLogin,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    dates: [],
    isShowType:1,
   
    datecount: [
      {
        id: 1,
        name: "1天"
      }, {
        id: 2,
        name: "2天"
      }, {
        id: 3,
        name: "3天"
      }, {
        id: 4,
        name: "4天"
      }, {
        id: 5,
        name: "5天"
      }, {
        id: 6,
        name: "6天"
      }, {
        id: 7,
        name: "7-8天"
      }, {
        id: 9,
        name: "9-10天"
      }, {
        id: 10,
        name: "10天以上"
      },
    ],
    onedaypageIndex:1,
    noData:false,
    search:{
      searchKey1: "",
      searchKey2: "",
      searchKey3: "",
    },
    lineMsg:{
      lineId:0,
      lineTeamId:0,
    },
    
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log("options", options)
    let City = this.selectComponent('#CityComp');
    City.getCityList();
    if (options.isShowType){
      this.data.isShowType = options.isShowType;
      this.setData({
        isShowType: this.data.isShowType
      })
    }
    if (options.searchKey){
      if (options.isShowType==1){
        this.data.search.searchKey1 = options.searchKey;
      }
      if (options.isShowType == 2) {
        this.data.search.searchKey2 = options.searchKey;
      }
      if (options.isShowType == 3) {
        this.data.search.searchKey3 = options.searchKey;
      }
      this.setData({
        search: this.data.search
      })
      
    }
    if (options.lineId){
      this.data.lineMsg.lineId = options.lineId;
      this.data.lineMsg.lineTeamId = options.ltId;
      this.setData({
        lineMsg: this.data.lineMsg
      })
    }
    let isShowType = this.data.isShowType;
    if (isShowType==1){
      this.oneDayShow();
    }
    if (isShowType == 2){
      this.ticketShow();
    }
    if (isShowType == 3) {
      this.localFood();
    }
    
    
  },
  oneDayShow(){
    let oneday = this.selectComponent('#oneday');
    oneday.getLine();
    oneday.getList();
  },
  ticketShow(){
    let ticket = this.selectComponent('#ticket');
    ticket.getCountry();
    ticket.getList();
  },
  localFood() {
    let localfood = this.selectComponent('#localfood');
    localfood.getCityItem();
    localfood.getList();
  },
  ChangeSite(val) {
    this.setData({
      site: val.detail
    })
    this.onLoad();
  },  
  // 点击改变出游方式
  changeType(e){
    let type=e.target.dataset.type;
    this.setData({
      isShowType: type,
      onedaypageIndex:1,
      noData:false
    })
    if (type==1){
      this.oneDayShow();
    }
    if(type==2){
      this.ticketShow();
    }
    if (type == 3) {
      this.localFood();
    }
    
  },
  onReachBottom: function () {
    let that = this;
    if (that.data.noData) return;
    wx.showNavigationBarLoading();
    let pageIndex = that.data.onedaypageIndex;
    // 每次下拉 page+1
    pageIndex = pageIndex + 1;
    that.data.onedaypageIndex = pageIndex;
    this.setData({
      onedaypageIndex: pageIndex
    })
    if (that.data.isShowType==1){
      that.oneDayShow();
    }
    if (that.data.isShowType == 2) {
      that.ticketShow();
    }
    if (that.data.isShowType == 3) {
      this.localFood();
    }

  },
  // 判断是否可以上拉
  oneDayInfo(e){
    console.log("eeee", e.detail)
    this.setData({
      noData: e.detail
    })
    wx.hideNavigationBarLoading()
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */



  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})