// pages/local/localHome/localhome.js
let app=getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    lineList:[],
    lineIndex:0,
    lineTeamList:[],
    toView:'oneday',
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    lineActive:0,
    abroadList:[],
    isLogin: app.isLogin,
    ticketList:[],
    foodList:[],
    lineId:0,
  },

  /**
   * 生命周期函数--监听页面加载
   */

  onLoad: function (options) {
    let City = this.selectComponent('#CityComp');
    City.getCityList();
    this.GetLine();
    this.getOneday();
    this.getTicket();
    this.getFood();
  },
  goFood(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/local/LocalFoodDetails/LocalFoodDetails?idDes=' + encodeURIComponent(item.idDes) + "&id=" + item.id,
    })
  },
  goTicket(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/local/TicketDetails/TicketDetails?idDes=' + encodeURIComponent(item.idDes),
    })
  },
  goGroup(e) {
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.idDes) + "&tcid=" + item.tcid + "&teamType=2",
    })
  },
  goOnedayList(e){
    let item = e.currentTarget.dataset.item;
    wx.navigateTo({
      url: '/pages/local/localTrip/localTrip?isShowType=1&lineId=' + this.data.lineId + "&ltId=" + item.ltId,
    })

  },
  getlineTeam(e) {
    console.log(e);
    let item = e.currentTarget.dataset.item;
    let index = e.currentTarget.dataset.index;
    this.setData({
      lineActive: index,
      lineTeamList: item.lineTeamList,
      lineId: item.lineId
    })
  },
  // 当地美食
  getFood() {
    let msg = {
      countryId: 0,
      pageIndex: 1,
      pageSize: 4,
      fromOrigin: 1,
    }
    app.$apiJavaNew('/api/b2b/food/getHomeFoodList', msg).then(res => {
      console.log("getFood")
      console.log(res);
      let list = res.pageData;

      this.setData({
        foodList: list
      })
      console.log("foodList", this.data.foodList);

    }).catch(err => { })
  },
  // 门票
  getTicket() {
    let msg = {
      pageIndex: 1,
      pageSize: 4,
      countryId: -1,
      fromOrigin: 1,
    }
    app.$apiJavaNew('/api/b2b/home/getHomeTicketCoupons', msg).then(res => {
      let list = res.pageData;

      this.setData({
        ticketList: list
      })

    }).catch(err => { })
  },
  // 境外一日游
  getOneday(){
    let msg = {
      pageIndex: 1,
      pageSize: 4,
      companyId: this.data.site.companyId,
      fromOrigin:1,
      }
    app.$apiJavaNew('/api/b2b/dayTrip/getHomeRecommendProduct', msg).then(res => {
      let abroadList = res.pageData;

      this.setData({
        abroadList: abroadList
      })


    }).catch(err => {})
  },
 
  GetLine() {
    let that = this;
    app.$apiJavaNew('/api/b2b/dayTrip/getLineItem', {}).then(res => {
      let lineList=res;
      
      if (lineList.length>0){
        let arr = lineList[0].lineTeamList;
        that.setData({
          lineTeamList: arr
        })
      }
      that.setData({
        lineList: lineList
      })

    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 1000
      })
    })
  },
  Scrolltap(e) {
    let color = e.target.dataset.index;
    this.setData({
      toView: color
    })
  },
  ChangeSite(val) {
    console.log(val.detail);
    this.setData({
      site: val.detail
    })
    this.onLoad();
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})