// pages/local/oneday/oneday.js
let app=getApp();
var util = require('../../../utils/util.js')
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    pageIndex:{
      type:'number'
    },
    searchKey:{
      type: 'String'
    },
    lineTeamId: {
      type: 'Number'
    },
    lineId: {
      type: 'Number'
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    ScreenStatus: false,
    lineList:[],
    isLogin:app.isLogin,
    site: {
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      siteName: app.state.siteName,
    },
    msg: {
      pageIndex: 1,
      pageSize: 5,
      lineId: 0,
      lineTeamId: 0,
      startDate: "",
      endDate: "",
      minPrice: -1,
      maxPrice: -1,
      companyId: app.state.companyId,
      cityId: app.state.cityId,
      priceOrderByField: 2,
      orderByPrice: 0,
      orderBySales: 0,
      searchKey: "",
      startCityId: 0,
      countryId: 0,
      cityId: 0,
    },
    lineTeamList:[],
    dataList:[],
    noData:false,
  },

  /**
   * 组件的方法列表
   */
  methods: {
    goGroup(e){
      let item = e.currentTarget.dataset.item;
      wx.navigateTo({
        url: '/pages/GroupTour/GroupDetails/GroupDetails?idDes=' + encodeURIComponent(item.idDes) + "&tcid=" + item.tcid + "&teamType=2",
      })
    },
    zhpx(){
      this.data.msg.orderByPrice = 0;
      this.data.msg.orderBySales = 0;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    bySale(){
      let sale = this.data.msg.orderBySales;
      sale == 0 ? sale = 1 :sale=0;
      this.data.msg.orderByPrice=0;
      this.data.msg.orderBySales = sale;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    byPrice() {
      let orderByPrice = this.data.msg.orderByPrice;

      orderByPrice == 0 ? orderByPrice = 1 : orderByPrice=0;
      this.data.msg.orderByPrice = orderByPrice;
      this.data.msg.orderBySales=0;
      this.setData({
        msg: this.data.msg
      })
      this.getList();
    },
    getList(){
      this.data.msg.searchKey = this.data.searchKey;
      this.data.msg.pageIndex = this.properties.pageIndex;
      this.data.msg.lineTeamId = this.data.lineTeamId;
      this.data.msg.lineId = this.properties.lineId;
      this.setData({
        msg: this.data.msg
      })
      let dataList = this.data.dataList;
      app.$apiJavaNew('/api/b2b/dayTrip/getDayTripProductList', this.data.msg).then(res => {
        
        
        if (res.pageData.length < 5) {
          this.setData({
            noData: true
          })

        }
        res.pageData.forEach(item => {
          dataList.push(item)
        })
        this.setData({
          dataList: dataList
        })
        this.triggerEvent('oneDayInfo', this.data.noData )

      }).catch(err => { })
    },
    screenOpen(){
      this.setData({
        ScreenStatus:true,
      })
    },
    closeScreen(e) {

      if (e.target.dataset.target == "self") {
        this.setData({
          ScreenStatus: false,

        })
      }
    },
    minPriceInput(e){
      this.data.msg.minPrice = e.detail.value;
      this.setData({
        msg: this.data.msg
      })
    },
    maxPriceInput(e) {
      this.data.msg.maxPrice = e.detail.value;
      this.setData({
        msg: this.data.msg
      })
    },
    bindDateChange(e){
      
      let type = e.currentTarget.dataset.type;
      let val = e.detail.value;
      if(type=="start"){
        this.data.msg.startDate=val;
      }else{
        this.data.msg.endDate = val;
      }
      this.setData({
        msg: this.data.msg
      })
      if (util.CompareDate(this.data.msg.startDate, this.data.msg.endDate)){
        wx.showToast({
          title: "请选择正确的日期！",
          icon: 'none',
          duration: 1000
        })
      }
      
    },
    // 获取线路
    getLine() {
      app.$apiJavaNew('/api/b2b/dayTrip/getLineItem', {}).then(res => {
        this.setData({
          lineList: res
        })

      }).catch(err => { })
    },
    getlineTeam(e){
      let item = e.currentTarget.dataset.item;
      
      if (item){
        this.data.msg.lineId = item.lineId
        this.setData({
          lineTeamList: item.lineTeamList,
          msg: this.data.msg
        })
      }else{
        this.data.msg.lineId =0;
        this.setData({
          lineTeamList:[],
          msg: this.data.msg
        })
      }
    },
    getlineTeamId(e){
      let item = e.currentTarget.dataset.item;
      this.data.msg.lineTeamId = item
      this.setData({
        msg: this.data.msg
      })
    }
  }
})
