              // pages/login/login.js

let app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    loginState: false,
    isPwd: true,
    account: '',
    password: ''
  },
  
  /**
   * 密码可见状态切换
   */
  pwdToShow: function () {
    this.setData({
      isPwd: !this.data.isPwd
    })
  },

  /**
   * 账号输入
   */
  bindAccountInput: function (e) {
    let loginState = false
    if (e.detail.value !== '' && this.data.password !== '') {
      loginState = true
    }
    this.setData({
      account: e.detail.value,
      loginState: loginState
    })
  },

  /**
   * 密码输入
   */
  bindPasswordInput: function (e) {
    let loginState = false
    if (e.detail.value !== '' && this.data.account !== '') {
      loginState = true
    }
    this.setData({
      password: e.detail.value,
      loginState: loginState
    })
  },
  /**
   * 登录
   */
  signIn: function (e) {
    if (this.data.loginState === true) {
      wx.login({
        success: res => {
          if (res.code) {
            let data = {
              account: this.data.account,
              password: this.data.password,
              code: res.code
            }
            app.$api('miniProgram_customer_Login', data).then(res => {
              app.state.admin = res
              console.log(app.state.admin)
              wx.setStorage({
                key: "admin",
                data: {
                  account: res.account,
                  address: res.address,
                  businessCardPhotos: res.businessCardPhotos,
                  contact: res.contact,
                  customerAccountId: res.customerAccountId,
                  housePhotos: res.housePhotos,
                  images: res.images,
                  isMember: res.isMember,
                  name: res.name,
                  photo: res.photo,
                  secretKey: res.secretKey,
                  token: res.token,
                  customerName: res.customerName,
                  id: res.id
                }
              })
              wx.navigateBack({
                delta: 1
              })
              let formId = e.detail.formId
              app.$apiSaveFormId('survey_post_SaveFormId', { formId: formId, customerId: res.id }).then(res => {

              }).catch(err => { })
            }).catch(err => {
              if (err.resultCode === 10007) {
                wx.navigateTo({
                  url: '/pages/login/activate/activate'
                })
              }
            })
          } else {
            wx.showToast({
              title: '获取用户信息失败',
              icon: 'none',
              duration: 1000
            })
          }
        }
      })
    }
  },

  /**
   * 微信登录
   */
  signWx: function (e) {
    wx.login({
      success: res => {
        if (res.code) {
          app.$api('miniProgram_customer_LoginByOpenId', {code: res.code}).then(res => {
            app.state.admin = res
            wx.setStorage({
              key: "admin",
              data: {
                account: res.account,
                address: res.address,
                businessCardPhotos: res.businessCardPhotos,
                contact: res.contact,
                customerAccountId: res.customerAccountId,
                housePhotos: res.housePhotos,
                images: res.images,
                isMember: res.isMember,
                name: res.name,
                photo: res.photo,
                secretKey: res.secretKey,
                token: res.token,
                id: res.id
              }
            })
            wx.reLaunch({
              url: '/pages/mine/mine'
            })
          }).catch(err => {
            if (err.resultCode === 10007) {
              wx.navigateTo({
                url: '/pages/login/activate/activate'
              })
            }
          })
        } else {
          wx.showToast({
            title: '获取用户信息失败',
            icon: 'none',
            duration: 1000
          })
        }
      }
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.setNavigationBarColor({
      frontColor: '#000000',
      backgroundColor: '#ffffff',
      animation: {}
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  }
})