let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    active: 0,
    dropdownActive: 0,
    tagBoxShow: false,
    dropdown: [
      {
        id: 1,
        name: '通用'
      },
      {
        id: 2,
        name: '跟团游'
      },
      {
        id: 3,
        name: '签证'
      },
      {
        id: 4,
        name: '机票'
      },
      // {
      //   id: 0,
      //   name: '当地游'
      // },
      // {
      //   id: 0,
      //   name: '定制游'
      // },
      // {
      //   id: 0,
      //   name: '酒店'
      // },
    ],
    TitList: [
      {
        id: 0,
        Status: 1,
        name: '全部优惠券'
      },
      {
        id: 2,
        Status: 1,
        name: '折扣券'
      },
      {
        id: 1,
        Status: 1,
        name: '抵扣券'
      },
      {
        id: 0,
        Status: 3,
        name: '已过期'
      },
    ],
    msg: {
      pageIndex: 1,
      pageSize: 8,
      useState: 1,
      lineId: 0,
      lineteamId: 0,
      couponsName: "",
      couponsType: "",
      couponStatus: 1,
      couponEffectStatus: 1,
      couponsUseScope: 1
    },
    dataList: [],
    pageIndex: 1,
    totalPage: 1,
    count: 0,
  },

  formSubmit: function (e) {
    wx.getStorage({
      key: 'admin',
      success: res => {
        console.log(e)
        let type = e.detail.target.dataset.type;
        let formId = e.detail.formId
        let url = '';
        if (url == 1 || type == 2) {
          url = '/pages/Home/home'
        } else if (type == 3) {
          url = '/pages/visa/visa'
        } else if (type == 4) {
          url = '/pages/Ticket/Ticket'
        }
        app.$apiSaveFormId('survey_post_SaveFormId', { formId: formId, customerId: res.data.id }).then(res => {
          
        }).catch(err => { })
        if (url == 1 || type == 2) {
          url = '/pages/Home/home'
          wx.switchTab({
            url: url,
          })
        } else if (type == 3) {
          url = '/pages/visa/visa'
          wx.navigateTo({
            url: url,
          })
        } else if (type == 4) {
          url = '/pages/Ticket/Ticket'
          wx.navigateTo({
            url: url,
          })
        }
        
      }
    })

  },
  // 加载更多
  scrollGetMore: function () {
    this.setData({
      'msg.pageIndex': this.data.pageIndex + 1,
    })
    this.getList(1)
  },
  // 获取数据
  getList: function (type) {
    console.log(this.data.pageIndex, this.data.totalPage, type)
    if (this.data.pageIndex >= this.data.totalPage && type) {
      return
    }
    app.$apiJavaNew('api/b2b/user/getUserCouponAllotList', this.data.msg).then(res => {
      let arr = this.data.dataList;
      let arr2 = res.pageData;
      if (type) { 
        for (let i = 0; i < arr2.length; i++) {
          arr2[i].effectDate = arr2[i].effectDate.split(' ')[0]
          arr2[i].expirationDate = arr2[i].expirationDate.split(' ')[0]
          arr.push(arr2[i])
        }
      } else {
        for (let i = 0; i < arr2.length; i++) {
          arr2[i].effectDate = arr2[i].effectDate.split(' ')[0]
          arr2[i].expirationDate = arr2[i].expirationDate.split(' ')[0] 
        }
        arr = arr2
      }
      this.setData({
        dataList: arr,
        totalPage: res.pageCount ? res.pageCount : 1,
        pageIndex: res.pageIndex ? res.pageIndex : 1,
        count: res.count ? res.count : 1
      })
    }).catch(err => { })
  },
  //切换类型
  setActiveTag: function (e) {
    let index = e.target.id.split('active')[1]
    console.log(index)
    this.setData({
      dropdownActive: Number(index),
      tagBoxShow: false,
      'msg.couponsUseScope': this.data.dropdown[Number(index)].id
    })
    this.getList()
  },
  // 切换状态
  setActive: function (e) {
    let index = e.target.id.split('active')[1]
    this.setData({
      active: Number(index),
      tagBoxShow: false,
      'msg.couponsType': this.data.TitList[Number(index)].id,
      'msg.couponEffectStatus': Number(index) == 3 ? 3 : 1,
    })
  this.getList()
  },
  // 切换类型显示？
  setShow: function () {
    this.setData({
      tagBoxShow: !this.data.tagBoxShow
    })
    
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.getList()
    wx.setNavigationBarTitle({
      title: '我的优惠券'
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})