let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    active: 0,
    tagBoxShow: false,
    tagBoxActive: 0,
    getOrderMsg: {
      pageIndex: 1,
      pageSize: 10,
      orderType: 1,
      queryDays: 0,
      orderState: 1,
      CustomerId: ""
    },
    userInfo: {},
    dataList: [],
    pageIndex: 1,
    totalPage: 1,
    count: 0,
    tagID: 1,
    tagIndex: 0,
  },
  formSubmit: function (e) {
    wx.getStorage({
      key: 'admin',
      success: res => {
        let url = e.detail.target.dataset.url;
        let index = e.detail.target.dataset.index;
        let formId = e.detail.formId;
        app.$apiSaveFormId('survey_post_SaveFormId', { formId: formId, customerId: res.data.id }).then(res => {
          console.log(res)
        }).catch(err => { })
        if (this.data.dataList[Number(index)].getScoreNum > -1) {
          wx.navigateTo({
            url: url + '?orderId=' + this.data.dataList[Number(index)].orderId,
          })
        }
      }
    })
  },
  // 加载更多
  scrollGetMore: function () {
    console.log(1)
    this.setData({
      'getOrderMsg.pageIndex': this.data.pageIndex + 1
    })
    this.getOrderList(1)
  },
  // 获取数据
  getOrderList: function (type) {
    let url = 'api/b2b/user/getrecentorder',
      msg = this.data.getOrderMsg;
    if (this.data.pageIndex >= this.data.totalPage && type) {
      return
    }
    this.data.getOrderMsg.CustomerId = this.data.userInfo.id
    app.$apiJavaNew(url, msg).then(res => {
      let arr = this.data.dataList;
      let arr2 = res.pageData
      for (let i = 0; i < arr2.length; i++) {
        arr2[i].day = arr2[i].createDate.replace(/-/g, '.').substring(0, 10)
      }
      if (type) {
        for (let i = 0; i < arr2.length; i++) {
          arr.push(arr2[i])
        }
      } else {
        arr = arr2
      }
      this.setData({
        dataList: arr,
        totalPage: res.pageCount,
        pageIndex: res.pageIndex,
        count: res.count
      })
    }).catch(err => { })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let userInfo = wx.getStorageSync('admin');
    this.setData({
      userInfo: userInfo,
    })
    this.getOrderList()
    wx.setNavigationBarTitle({
      title: '意见调查列表'
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})