let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    progress: 0,
    userInfo: {},
    custormInfo: {},
    memberNextExp: {},
    gap: 0,
    nextExp: 0,
    isLogin: false,
  },
  formSubmit: function (e) {
    wx.getStorage({
      key: 'admin',
      success: res => {  
        console.log(e)
        let url = e.detail.target.dataset.url;
        let formId = e.detail.formId
        app.$apiSaveFormId('survey_post_SaveFormId', { formId: formId, customerId: res.data.id }).then(res => {
          console.log(res)
        }).catch(err => { })
        wx.navigateTo({
          url: url,
        })
      }
    })
    
  },
  formReset: function () {
    console.log('form发生了reset事件')
  },
  getInfo: function () {
    app.$apiJavaNew("api/b2b/user/getSimpleUser", { account: this.data.userInfo.account }).then(res => {
      this.setData({
        custormInfo: res,
      })
    }).catch(err => { })
  },
  getUserMemberExp: function () {
    app.$apiJavaNew("api/member/getUserMemberExp", { customer: this.data.userInfo.customerAccountId }).then(res => {
      let NextExp = (((res.next.nextExp - res.next.gap) / res.next.nextExp) * 100).toFixed(2)
      this.setData({
        progress: NextExp,
        gap: res.next.gap,
        nextExp: res.next.nextExp - res.next.gap,
      })
    }).catch(err => { })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let userInfo = wx.getStorageSync('admin');
    if (userInfo) {
      this.setData({
        isLogin: true,
        userInfo: userInfo,
        photo: app.state.admin.photo === null ? '' : app.state.admin.photo,
        isMember: app.state.admin.isMember,
        account: app.state.admin.account,
        address: app.state.admin.address,
        businessCardPhotos: app.state.admin.businessCardPhotos === null ? [] : app.state.admin.businessCardPhotos,
        housePhotos: app.state.admin.housePhotos === null ? [] : app.state.admin.housePhotos,
        images: app.state.admin.images === null ? [] : app.state.admin.images
      })
      this.getInfo()
      this.getUserMemberExp()
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    wx.setNavigationBarTitle({
      title: '个人中心'
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    let userInfo = wx.getStorageSync('admin');
    if (userInfo) {
      this.setData({
        isLogin: true,
        userInfo: userInfo,
        photo: app.state.admin.photo === null ? '' : app.state.admin.photo,
        isMember: app.state.admin.isMember,
        account: app.state.admin.account,
        address: app.state.admin.address,
        businessCardPhotos: app.state.admin.businessCardPhotos === null ? [] : app.state.admin.businessCardPhotos,
        housePhotos: app.state.admin.housePhotos === null ? [] : app.state.admin.housePhotos,
        images: app.state.admin.images === null ? [] : app.state.admin.images
      })
      this.getInfo()
      this.getUserMemberExp()
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})