// pages/member/memberInfoED/memberInfoED.js
let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    index: 0,
    branchList: [], 
    custormInfo: {},
    brandList: [],
  },
  inputName: function (e) {
    this.data.custormInfo.customerName = e.detail.value
  },
  inputNumber: function (e) {
    this.data.custormInfo.contactNumber = e.detail.value
  },
  inputAddr: function (e) {
    this.data.custormInfo.address = e.detail.value
  },
  seveMsg: function () {
    const phoneReg = /(^1[3|4|5|7|8|6]\d{9}$)|(^09\d{8}$)/;
    //电话 验证
    let _this = this;
    let phone = this.data.custormInfo.contactNumber.replace(/^\s+|\s+$/gm, "");
    if (!phoneReg.test(_this.data.custormInfo.contactNumber)) {
      wx.showToast({
        title: '请输入有效的手机号码！',
        icon: 'none',
        duration: 1000
      })
      return
    }
    if (!_this.data.custormInfo.address) {
      wx.showToast({
        title: '请填写所在地址',
        icon: 'none',
        duration: 1000
      })
      return
    }
    if (!_this.data.custormInfo.customerName) {
      wx.showToast({
        title: '请填写门店名称',
        icon: 'none',
        duration: 1000
      })
      return
    }
    let list = [];
    this.data.branchList.forEach(x => {
      list.push(x.brandId)
    })
    this.data.custormInfo.brandIds = list;
    app.$api('b2b_post_ModifyCustomerManagerInfo', this.data.custormInfo).then(res => {
      wx.navigateBack({
        delta: 2
      })
    }).catch(err => { 
    })
  },
  deleteItem: function (e) {
    let index = e.target.id.split('item')[1]
    this.data.branchList.splice(index, 1)
    this.setData({
      branchList: this.data.branchList
    })
  },
  getUserInfo: function () {
    app.$api("b2b_get_GetCustomerManagerInfo", {}).then(res => {
      this.setData({
        custormInfo: res,
        branchList: res.branchList
      })
    }).catch(err => { })
  },
  app_get_customer_brand: function () {  // 获取品牌
    app.$api('app_get_customer_brand', {}).then(res => {
      this.setData({
        brandList: res
      })
    }).catch(err => { })
  },
  bindPickerChange: function (e) {
    let index = e.detail.value
    let list = this.data.branchList
    let isTags = false;
    this.data.brandList.map((x, i)=>{
      console.log(index, typeof index)
      if (index == i) {
        console.log(x)
        list.map(y=>{
          console.log(y)
          if (y.brandId == x.id) {
            isTags = true
          }
        })
        if (!isTags) {
          list.push({
            brandName: x.name,
            brandId: x.id
          })
        }
      }
    })
    this.setData({
      branchList: list
    })
    console.log('picker发送选择改变，携带值为', e.detail.value)
    // this.setData({
    //   index: e.detail.value
    // })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.getUserInfo();
    this.app_get_customer_brand()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    //修改title
    wx.setNavigationBarTitle({
      title: '编辑门店基本资料'
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})