let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    msg: {
      id: 0,
      province: '',
      city: '',
      district: '',
      address: '',
      uname: '',
      uphone: '',
      postcode: '',
    },
    province: '',
    city: '',
    county: '',
  },
  seveMsg: function () {
    if (!this.data.msg.uname){
      wx.showToast({
        title: '请填写收货人',
        icon: 'none',
        duration: 1000
      })
      return
    }
    if (!this.data.msg.uphone) {
      wx.showToast({
        title: '请填写手机号',
        icon: 'none',
        duration: 1000
      })
      return
    }
    if (!this.data.msg.address) {
      wx.showToast({
        title: '请填写详细地址',
        icon: 'none',
        duration: 1000
      })
      return
    }
    app.$apiJavaNew("api/orderForm/saveOrUpdateOrderAdd", this.data.msg).then(res => {
      wx.showToast({
        title: '修改成功',
        icon: 'none',
        duration: 1000
      })
      setTimeout(() => {
        wx.navigateBack({
          delta: 2
        })
      }, 1000)
    }).catch(err => { })
  },
  regionChange: function (e) {
    console.log(e)
    this.setData({
      province: e.detail.province,
      city: e.detail.city,
      county: e.detail.county,
      'msg.province': e.detail.province,
      'msg.city': e.detail.city,
      'msg.district': e.detail.district,
    });
  },
  inputName: function (e) {
    console.log(e)
    let id = e.target.id,
    value = e.detail.value;
    if (id == 'name') {
      this.setData({
        'msg.uname': value
      })
    } else if (id == 'phone') {
      this.setData({
        'msg.uphone': value
      })
    }else if (id == 'details') {
      this.setData({
        'msg.address': value
      })
    }
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      'msg.id': options.id
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    //修改title
    wx.setNavigationBarTitle({
      title: '修改收货地址'
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})