let app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    active: 0,
    TitList: [],
    TitListTc: [
      {
        Type: "待付定金",
        ID: 1,
      },
      {
        Type: "待付尾款",
        ID: 2,
      },
      {
        Type: "待发团",
        ID: 3,
      },
      {
        Type: "交易完成",
        ID: 4,
      },
      {
        Type: "取消",
        ID: 0,
      }
    ],
    TitListMenJi: [
      {
        Type: "正常",
        ID: 1,
      },
      {
        Type: "取消",
        ID: 2,
      },
      {
        Type: "待付款",
        ID: 3,
      }
    ],
    TitListJiPiao: [
      {
        Type: "待付款",
        ID: 1
      },   
      {
        Type: "正常",
        ID: 2
      },
      {
        Type: "取消",
        ID: 3
      }
    ],
    tagList: [
      {
        id: 1,
        name: '跟团游',
        Class: 'tuan'
      },
      {
        id: 2,
        name: '自由行',
        Class: 'ziyou'
      },
      {
        id: 3,
        name: '当地游',
        Class: 'dangdi'
      },
      {
        id: 4,
        name: '机票',
        Class: 'jipiao'
      },
      {
        id: 5,
        name: '签证',
        Class: 'qianzheng'
      },
      {
        id: 6,
        name: '门票',
        Class: 'menpiao'
      },
      {
        id: 7,
        name: '定制游',
        Class: 'dingzhi'
      },
      {
        id: 8,
        name: '美食',
        Class: 'meishi'
      },
    ],
    tagBoxShow: false,
    tagBoxActive: 0,
    getOrderMsg: {
      pageIndex: 1,
      pageSize: 5,
      orderType: 1,
      queryDays: 0,
      orderState: 1,
      CustomerId: ""
    },
    userInfo: {},
    dataList: [],
    pageIndex: 1,
    totalPage: 1,
    count: 0,
    listClass: 'tuan',
    tagID: 1,
    tagIndex: 0,
  },
  formSubmit: function (e) {
    console.log(e)
    wx.getStorage({
      key: 'admin',
      success: res => { 
        let index = e.currentTarget.dataset.index;
        // let formId = e.detail.formId
        // app.$apiSaveFormId('survey_post_SaveFormId', { formId: formId, customerId: res.data.id }).then(res => {
        //   console.log(res)
        // }).catch(err => { }) 
        this.goDetails(index)
      }
    })
  },
  endPaoPao: function () {
    console.log('阻止冒泡····')
  },
  // 跳转详情页面
  goDetails: function (e) {
    let index = e,
      item = this.data.dataList[index];
    let orderId = item.orderId ? item.orderId : item.id
    wx.setStorage({
      key: "DetailsItem",
      data: item
    })
    wx.navigateTo({
      url: '/pages/member/orderDeatils/orderDeatils?tagID=' + this.data.tagID + '&tagIndex=' + this.data.tagIndex + '&orderId=' + orderId,
    })
  },
  // 加载更多
  scrollGetMore: function () {
    this.setData({
      'getOrderMsg.pageIndex': this.data.pageIndex + 1,
    })
    this.getOrderList(1)
  },
  // 获取数据
  getOrderList: function (type) {
    let url = 'api/b2b/user/getrecentorder',
      tagID = this.data.tagID, 
      msg = this.data.getOrderMsg;
    if (tagID !== 6 && tagID !== 8 && tagID !== 4) {
      // console.log(tagID)
      url = 'api/b2b/user/getrecentorder'
    } else if (tagID !== 4){  // 8美食 6门票
      msg.status = msg.orderState
      url = tagID == 8 ? 'api/b2b/food/getFoodOrder' : 'api/b2b/scenic/getTicketCouponsOrder'
    } else {
      msg.status = msg.orderState
      url = 'api/b2b/user/getAirTicketOrder'
    }
    this.data.getOrderMsg.CustomerId = this.data.userInfo.id
    if (this.data.pageIndex >= this.data.totalPage && type){
      return
    }
    app.$apiJavaNew(url, msg).then(res => {
      let arr = this.data.dataList;
      let arr2 = res.pageData ? res.pageData : [];
      for (let i = 0; i < arr2.length; i++) {
        if (tagID !== 6 && tagID !== 8) {
          arr2[i].day = arr2[i].createDate.replace(/-/g, '.').substring(0, 10)
        } else {
          arr2[i].day = arr2[i].useDate.replace(/-/g, '.')
        }
      }
      if (type) {
        console.log(type, '组装数据')
        for (let i = 0; i < arr2.length; i++){
          arr.push(arr2[i])
        }
      } else {
        arr = arr2
      }
      this.setData({
        dataList: arr,
        totalPage: res.pageCount ? res.pageCount : 1,
        pageIndex: res.pageIndex ? res.pageIndex : 1,
        count: res.count ? res.count : 1
      })
    }).catch(err => { })
  },
  // 切换订单类型
  setActiveTag: function (e) {
    let index = e.target.id.split('active')[1], TitList = [];
    if (index == this.data.tagBoxActive) {
      index = 0
    } else {
      index = Number(e.target.id.split('active')[1])
    }
    if (this.data.tagList[index].name !== '美食' && this.data.tagList[index].name !== '门票' && this.data.tagList[index].name !== '机票'){
      TitList = this.data.TitListTc
    } else if ( this.data.tagList[index].name == '机票'){
      TitList = this.data.TitListJiPiao
    } else {
      TitList = this.data.TitListMenJi
    }
    this.setData({
      tagBoxActive: index,
      tagBoxShow: false,
      'getOrderMsg.orderType': this.data.tagList[index].id,
      pageIndex: 1,
      TitList: TitList,
      tagID: this.data.tagList[index].id,
      tagIndex: index + 1
    })
    this.getOrderList()
  },
  // 切换类型显示？
  setShow: function () {
    this.setData({
      tagBoxShow: !this.data.tagBoxShow
    })
  },
  // 切换订单状态
  setActive: function (e) {
    this.setData({
      active: e.target.id.split('active')[1],
      'getOrderMsg.orderState': Number(e.target.id.split('active')[1]) + 1,
      pageIndex: 1,
    })
    this.getOrderList()
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let userInfo = wx.getStorageSync('admin');
    let index = options.index ? Number(options.index) : 1
    let TitList = [];
    if (this.data.tagList[index - 1].name !== '美食' && this.data.tagList[index - 1].name !== '门票' && this.data.tagList[index - 1].name !== '机票') {
      TitList = this.data.TitListTc
    } else if (this.data.tagList[index - 1].name == '机票') {
      TitList = this.data.TitListJiPiao
    } else {
      TitList = this.data.TitListMenJi
    }
    if (index) {
      this.setData({
        tagBoxActive: index - 1,
        userInfo: userInfo,
        TitList: TitList,
        tagID: this.data.tagList[index - 1].id,
        'getOrderMsg.orderType':  this.data.tagList[index - 1].id,
        tagIndex: index
      })
    }else{
      this.setData({
        userInfo: userInfo,
        TitList: this.data.TitListTc
      })
    }
    this.getOrderList()
    wx.setNavigationBarTitle({
      title: '订单中心'
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})